import bisect

# from java.lang.Character.UnicodeBlock, with slight differeneces

_BLOCK_STARTS, _BLOCK_NAMES = (lambda x: (
    [i[0] for i in x], [i[1] for i in x]))([
    (0x0000, None),
    (0x0020, 'SPACE'),
    (0x0021, 'BASIC_PUNCTUATION'),
    (0x0030, 'DIGIT'),
    (0x003A, 'BASIC_PUNCTUATION'),
    (0x0041, 'BASIC_LATIN'),
    (0x005B, 'BASIC_PUNCTUATION'),
    (0x0061, 'BASIC_LATIN'),
    (0x007B, 'BASIC_PUNCTUATION'),
    (0x007f, None),
    (0x00A0, 'LATIN_1_SUPPLEMENT'),
    (0x00C0, 'LATIN_EXTENDED_LETTER'),
    (0x0100, 'LATIN_EXTENDED_A'),
    (0x0180, 'LATIN_EXTENDED_B'),
    (0x0250, 'IPA_EXTENSIONS'),
    (0x02B0, 'SPACING_MODIFIER_LETTERS'),
    (0x0300, 'COMBINING_DIACRITICAL_MARKS'),
    (0x0370, 'GREEK'),
    (0x0400, 'CYRILLIC'),
    (0x0500, 'CYRILLIC_SUPPLEMENTARY'),
    (0x0530, 'ARMENIAN'),
    (0x0590, 'HEBREW'),
    (0x0600, 'ARABIC'),
    (0x0700, 'SYRIAC'),
    (0x0750, 'ARABIC_SUPPLEMENT'),
    (0x0780, 'THAANA'),
    (0x07C0, 'NKO'),
    (0x0800, 'SAMARITAN'),
    (0x0840, 'MANDAIC'),
    (0x0860, None),
    (0x0900, 'DEVANAGARI'),
    (0x0980, 'BENGALI'),
    (0x0A00, 'GURMUKHI'),
    (0x0A80, 'GUJARATI'),
    (0x0B00, 'ORIYA'),
    (0x0B80, 'TAMIL'),
    (0x0C00, 'TELUGU'),
    (0x0C80, 'KANNADA'),
    (0x0D00, 'MALAYALAM'),
    (0x0D80, 'SINHALA'),
    (0x0E00, 'THAI'),
    (0x0E80, 'LAO'),
    (0x0F00, 'TIBETAN'),
    (0x1000, 'MYANMAR'),
    (0x10A0, 'GEORGIAN'),
    (0x1100, 'HANGUL_JAMO'),
    (0x1200, 'ETHIOPIC'),
    (0x1380, 'ETHIOPIC_SUPPLEMENT'),
    (0x13A0, 'CHEROKEE'),
    (0x1400, 'UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS'),
    (0x1680, 'OGHAM'),
    (0x16A0, 'RUNIC'),
    (0x1700, 'TAGALOG'),
    (0x1720, 'HANUNOO'),
    (0x1740, 'BUHID'),
    (0x1760, 'TAGBANWA'),
    (0x1780, 'KHMER'),
    (0x1800, 'MONGOLIAN'),
    (0x18B0, 'UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED'),
    (0x1900, 'LIMBU'),
    (0x1950, 'TAI_LE'),
    (0x1980, 'NEW_TAI_LUE'),
    (0x19E0, 'KHMER_SYMBOLS'),
    (0x1A00, 'BUGINESE'),
    (0x1A20, 'TAI_THAM'),
    (0x1AB0, None),
    (0x1B00, 'BALINESE'),
    (0x1B80, 'SUNDANESE'),
    (0x1BC0, 'BATAK'),
    (0x1C00, 'LEPCHA'),
    (0x1C50, 'OL_CHIKI'),
    (0x1C80, None),
    (0x1CD0, 'VEDIC_EXTENSIONS'),
    (0x1D00, 'PHONETIC_EXTENSIONS'),
    (0x1D80, 'PHONETIC_EXTENSIONS_SUPPLEMENT'),
    (0x1DC0, 'COMBINING_DIACRITICAL_MARKS_SUPPLEMENT'),
    (0x1E00, 'LATIN_EXTENDED_ADDITIONAL'),
    (0x1F00, 'GREEK_EXTENDED'),
    (0x2000, 'GENERAL_PUNCTUATION'),
    (0x2070, 'SUPERSCRIPTS_AND_SUBSCRIPTS'),
    (0x20A0, 'CURRENCY_SYMBOLS'),
    (0x20D0, 'COMBINING_MARKS_FOR_SYMBOLS'),
    (0x2100, 'LETTERLIKE_SYMBOLS'),
    (0x2150, 'NUMBER_FORMS'),
    (0x2190, 'ARROWS'),
    (0x2200, 'MATHEMATICAL_OPERATORS'),
    (0x2300, 'MISCELLANEOUS_TECHNICAL'),
    (0x2400, 'CONTROL_PICTURES'),
    (0x2440, 'OPTICAL_CHARACTER_RECOGNITION'),
    (0x2460, 'ENCLOSED_ALPHANUMERICS'),
    (0x2500, 'BOX_DRAWING'),
    (0x2580, 'BLOCK_ELEMENTS'),
    (0x25A0, 'GEOMETRIC_SHAPES'),
    (0x2600, 'MISCELLANEOUS_SYMBOLS'),
    (0x2700, 'DINGBATS'),
    (0x27C0, 'MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A'),
    (0x27F0, 'SUPPLEMENTAL_ARROWS_A'),
    (0x2800, 'BRAILLE_PATTERNS'),
    (0x2900, 'SUPPLEMENTAL_ARROWS_B'),
    (0x2980, 'MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B'),
    (0x2A00, 'SUPPLEMENTAL_MATHEMATICAL_OPERATORS'),
    (0x2B00, 'MISCELLANEOUS_SYMBOLS_AND_ARROWS'),
    (0x2C00, 'GLAGOLITIC'),
    (0x2C60, 'LATIN_EXTENDED_C'),
    (0x2C80, 'COPTIC'),
    (0x2D00, 'GEORGIAN_SUPPLEMENT'),
    (0x2D30, 'TIFINAGH'),
    (0x2D80, 'ETHIOPIC_EXTENDED'),
    (0x2DE0, 'CYRILLIC_EXTENDED_A'),
    (0x2E00, 'SUPPLEMENTAL_PUNCTUATION'),
    (0x2E80, 'CJK_RADICALS_SUPPLEMENT'),
    (0x2F00, 'KANGXI_RADICALS'),
    (0x2FE0, None),
    (0x2FF0, 'IDEOGRAPHIC_DESCRIPTION_CHARACTERS'),
    (0x3000, 'CJK_SYMBOLS_AND_PUNCTUATION'),
    (0x3041, 'HIRAGANA'),
    (0x3097, 'CJK_SYMBOLS_AND_PUNCTUATION'),
    (0x30A1, 'KATAKANA'),
    (0x30fb, 'CJK_SYMBOLS_AND_PUNCTUATION'),
    (0x3100, 'BOPOMOFO'),
    (0x3130, 'HANGUL_COMPATIBILITY_JAMO'),
    (0x3190, 'KANBUN'),
    (0x31A0, 'BOPOMOFO_EXTENDED'),
    (0x31C0, 'CJK_STROKES'),
    (0x31F0, 'KATAKANA_PHONETIC_EXTENSIONS'),
    (0x3200, 'ENCLOSED_CJK_LETTERS_AND_MONTHS'),
    (0x3300, 'CJK_COMPATIBILITY'),
    (0x3400, 'CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A'),
    (0x4DC0, 'YIJING_HEXAGRAM_SYMBOLS'),
    (0x4E00, 'CJK_UNIFIED_IDEOGRAPHS'),
    (0xA000, 'YI_SYLLABLES'),
    (0xA490, 'YI_RADICALS'),
    (0xA4D0, 'LISU'),
    (0xA500, 'VAI'),
    (0xA640, 'CYRILLIC_EXTENDED_B'),
    (0xA6A0, 'BAMUM'),
    (0xA700, 'MODIFIER_TONE_LETTERS'),
    (0xA720, 'LATIN_EXTENDED_D'),
    (0xA800, 'SYLOTI_NAGRI'),
    (0xA830, 'COMMON_INDIC_NUMBER_FORMS'),
    (0xA840, 'PHAGS_PA'),
    (0xA880, 'SAURASHTRA'),
    (0xA8E0, 'DEVANAGARI_EXTENDED'),
    (0xA900, 'KAYAH_LI'),
    (0xA930, 'REJANG'),
    (0xA960, 'HANGUL_JAMO_EXTENDED_A'),
    (0xA980, 'JAVANESE'),
    (0xA9E0, None),
    (0xAA00, 'CHAM'),
    (0xAA60, 'MYANMAR_EXTENDED_A'),
    (0xAA80, 'TAI_VIET'),
    (0xAAE0, None),
    (0xAB00, 'ETHIOPIC_EXTENDED_A'),
    (0xAB30, None),
    (0xABC0, 'MEETEI_MAYEK'),
    (0xAC00, 'HANGUL_SYLLABLES'),
    (0xD7B0, 'HANGUL_JAMO_EXTENDED_B'),
    (0xD800, 'HIGH_SURROGATES'),
    (0xDB80, 'HIGH_PRIVATE_USE_SURROGATES'),
    (0xDC00, 'LOW_SURROGATES'),
    (0xE000, 'PRIVATE_USE_AREA'),
    (0xF900, 'CJK_COMPATIBILITY_IDEOGRAPHS'),
    (0xFB00, 'ALPHABETIC_PRESENTATION_FORMS'),
    (0xFB50, 'ARABIC_PRESENTATION_FORMS_A'),
    (0xFE00, 'VARIATION_SELECTORS'),
    (0xFE10, 'VERTICAL_FORMS'),
    (0xFE20, 'COMBINING_HALF_MARKS'),
    (0xFE30, 'CJK_COMPATIBILITY_FORMS'),
    (0xFE50, 'SMALL_FORM_VARIANTS'),
    (0xFE70, 'ARABIC_PRESENTATION_FORMS_B'),
    (0xFF00, 'HALFWIDTH_AND_FULLWIDTH_FORMS'),
    (0xFFF0, 'SPECIALS'),

    (0x10000, 'LINEAR_B_SYLLABARY'),
    (0x10080, 'LINEAR_B_IDEOGRAMS'),
    (0x10100, 'AEGEAN_NUMBERS'),
    (0x10140, 'ANCIENT_GREEK_NUMBERS'),
    (0x10190, 'ANCIENT_SYMBOLS'),
    (0x101D0, 'PHAISTOS_DISC'),
    (0x10200, None),
    (0x10280, 'LYCIAN'),
    (0x102A0, 'CARIAN'),
    (0x102E0, None),
    (0x10300, 'OLD_ITALIC'),
    (0x10330, 'GOTHIC'),
    (0x10350, None),
    (0x10380, 'UGARITIC'),
    (0x103A0, 'OLD_PERSIAN'),
    (0x103E0, None),
    (0x10400, 'DESERET'),
    (0x10450, 'SHAVIAN'),
    (0x10480, 'OSMANYA'),
    (0x104B0, None),
    (0x10800, 'CYPRIOT_SYLLABARY'),
    (0x10840, 'IMPERIAL_ARAMAIC'),
    (0x10860, None),
    (0x10900, 'PHOENICIAN'),
    (0x10920, 'LYDIAN'),
    (0x10940, None),
    (0x10A00, 'KHAROSHTHI'),
    (0x10A60, 'OLD_SOUTH_ARABIAN'),
    (0x10A80, None),
    (0x10B00, 'AVESTAN'),
    (0x10B40, 'INSCRIPTIONAL_PARTHIAN'),
    (0x10B60, 'INSCRIPTIONAL_PAHLAVI'),
    (0x10B80, None),
    (0x10C00, 'OLD_TURKIC'),
    (0x10C50, None),
    (0x10E60, 'RUMI_NUMERAL_SYMBOLS'),
    (0x10E80, None),
    (0x11000, 'BRAHMI'),
    (0x11080, 'KAITHI'),
    (0x110D0, None),
    (0x12000, 'CUNEIFORM'),
    (0x12400, 'CUNEIFORM_NUMBERS_AND_PUNCTUATION'),
    (0x12480, None),
    (0x13000, 'EGYPTIAN_HIEROGLYPHS'),
    (0x13430, None),
    (0x16800, 'BAMUM_SUPPLEMENT'),
    (0x16A40, None),
    (0x1B000, 'KANA_SUPPLEMENT'),
    (0x1B100, None),
    (0x1D000, 'BYZANTINE_MUSICAL_SYMBOLS'),
    (0x1D100, 'MUSICAL_SYMBOLS'),
    (0x1D200, 'ANCIENT_GREEK_MUSICAL_NOTATION'),
    (0x1D250, None),
    (0x1D300, 'TAI_XUAN_JING_SYMBOLS'),
    (0x1D360, 'COUNTING_ROD_NUMERALS'),
    (0x1D380, None),
    (0x1D400, 'MATHEMATICAL_ALPHANUMERIC_SYMBOLS'),
    (0x1D800, None),
    (0x1F000, 'MAHJONG_TILES'),
    (0x1F030, 'DOMINO_TILES'),
    (0x1F0A0, 'PLAYING_CARDS'),
    (0x1F100, 'ENCLOSED_ALPHANUMERIC_SUPPLEMENT'),
    (0x1F200, 'ENCLOSED_IDEOGRAPHIC_SUPPLEMENT'),
    (0x1F300, 'MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS'),
    (0x1F600, 'EMOTICONS'),
    (0x1F650, None),
    (0x1F680, 'TRANSPORT_AND_MAP_SYMBOLS'),
    (0x1F700, 'ALCHEMICAL_SYMBOLS'),
    (0x1F780, None),
    (0x20000, 'CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B'),
    (0x2A6E0, None),
    (0x2A700, 'CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C'),
    (0x2B740, 'CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D'),
    (0x2B820, None),
    (0x2F800, 'CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT'),
    (0x2FA20, None),
    (0xE0000, 'TAGS'),
    (0xE0080, None),
    (0xE0100, 'VARIATION_SELECTORS_SUPPLEMENT'),
    (0xE01F0, None),
    (0xF0000, 'SUPPLEMENTARY_PRIVATE_USE_AREA_A'),
    (0x100000, 'SUPPLEMENTARY_PRIVATE_USE_AREA_B'),
    (0x10FFFF, None),
])


def of(uchar):
    return _BLOCK_NAMES[bisect.bisect_right(_BLOCK_STARTS, ord(uchar)) - 1]
