package unimr.vod.hmac;

/*
 * RED5 Open Source Flash Server - http://www.osflash.org/red5
 * 
 * Copyright (c) 2006-2008 by respective authors (see below). All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or modify it under the 
 * terms of the GNU Lesser General Public License as published by the Free Software 
 * Foundation; either version 2.1 of the License, or (at your option) any later 
 * version.  
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along 
 * with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

import org.red5.server.adapter.ApplicationAdapter;
import org.red5.server.api.IBandwidthConfigure;
import org.red5.server.api.IConnection;
import org.red5.server.api.IScope;
import org.red5.server.api.stream.IServerStream;
import org.red5.server.api.stream.IStreamCapableConnection;
import org.red5.server.api.stream.support.SimpleConnectionBWConfig;

//import org.red5.logging.Red5LoggerFactory;
//import org.slf4j.Logger;

/**
 * @author Andreas Gabriel (gabriel@hrz.uni-marburg.de)
 * @author David Nax (naxd@hrz.uni-marburg.de)
 */

public class Application extends ApplicationAdapter
{
	//protected Logger log = Red5LoggerFactory.getLogger( Application.class );

	private IScope appScope;
	private IServerStream serverStream;  

	@Override
	public boolean appStart (IScope app)
	{
		super.appStart(app);
		log.info( "protectedVOD appStart" );
		System.out.println("protectedVOD appStart");
		appScope = app;
		registerStreamPlaybackSecurity( new PlaybackSecurityHmac() );
		return true;
	}

	@Override
	public void appStop (IScope app)
	{

		log.info( "protectedVOD appStop" );
		super.appStop(app);

	}

	@Override
	public boolean appConnect( IConnection conn , Object[] params )
	{
		String clientId = conn.getClient().getId();
		String ip = (String)conn.getRemoteAddress( );

		log.info( "appConnect" + " clientId: "+ clientId + " ip: " + ip);

		// Trigger calling of "onBWDone", required for some FLV players
		measureBandwidth(conn);
		if (conn instanceof IStreamCapableConnection) {
			IStreamCapableConnection streamConn = (IStreamCapableConnection) conn;
			SimpleConnectionBWConfig bwConfig = new SimpleConnectionBWConfig();
			bwConfig.getChannelBandwidth()[IBandwidthConfigure.OVERALL_CHANNEL] = 1024 * 1024;
			bwConfig.getChannelInitialBurst()[IBandwidthConfigure.OVERALL_CHANNEL] = 128 * 1024;
			streamConn.setBandwidthConfigure(bwConfig);
		}

		return super.appConnect(conn, params);
	}

	@Override
	public void appDisconnect( IConnection conn )
	{
		String clientId = conn.getClient().getId();
		String ip = (String)conn.getRemoteAddress( );

		log.info( "appDisconnect" + " clientId: "+ clientId + " ip: " + ip);

		if (appScope == conn.getScope() && serverStream != null) {
			serverStream.close();
		}

		super.appDisconnect(conn);
	}

}



