#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Copyright (c) 2013 Ilya Shalyapin, ishalyapin@gmail.com, www.ishalyapin.ru

import re
from lxml import etree
from xml.sax.saxutils import escape


class Node(object):

    def __init__(self, elem):
        self.elem = elem

    def __getattr__(self, name):
        for child in self.elem.iterchildren():
            if re.sub('[\-\.]', '_', child.tag) == name:
                return Node(child)

    def __getitem__(self, key):
        return self.elem.attrib[key]

    def get_children(self):
        return list(self)

    def __iter__(self):
        return (Node(child) for child in self.elem.getchildren())

    def __repr__(self):
        return "<Node: %s>" % self.elem.tag

    def __unicode__(self):
        return etree.tostring(self.elem, encoding='utf-8').decode('utf-8')

    def get_text(self):
        text = escape(self.elem.text or "")
        for child in self.elem.getchildren():
            text += etree.tostring(child, encoding='utf-8').decode('utf-8')
            text += escape(child.tail or "")
        return text

def parse(filename):
    tree = etree.parse(filename)
    return Node(tree.getroot())

def fromstring(xml):
    tree = etree.fromstring(xml)
    return Node(tree)

