#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Copyright (c) 2013 Ilya Shalyapin, ishalyapin@gmail.com, www.ishalyapin.ru

import unittest
from unittest import TestCase
from unwind import Node, fromstring


class UnwindTestCase(TestCase):

    def setUp(self):
        xml = u"""<?xml version="1.0" encoding="UTF-8"?>
        <page>
            <menu>
                <name aaa="bbb" ccc="ddd">Привет мир</name>
                <items>
                    <item>
                        <name rel="lala">Пункт 1</name>
                        <url>http://example1.com</url>
                    </item>
                    <item>
                        <name>Пункт 2</name>
                        <url>http://example2.com</url>
                    </item>
                </items>
            </menu>
            <spec-sy.mbols>Символы</spec-sy.mbols>

        </page>""".encode('utf-8')
        self.root = fromstring(xml)

    def test_get_text(self):
        self.assertEquals(self.root.menu.name.get_text(), u'Привет мир')

    def test_attrs(self):
        self.assertEquals(self.root.menu.name['aaa'], 'bbb')
        self.assertEquals(self.root.menu.name['ccc'], 'ddd')

    def test_unicode(self):
        text = self.root.menu.__unicode__()
        self.assertTrue(text.startswith('<menu>'))
        self.assertTrue(text.strip().endswith('</menu>'))
        self.assertIn(u'Пункт 1', text)

    def test_repr(self):
        self.assertEquals(self.root.menu.name.__repr__(), "<Node: name>")

    def test_get_children(self):
        self.assertEquals(self.root.menu.items.get_children()[0].name.get_text(), u'Пункт 1')
        self.assertEquals(self.root.menu.items.get_children()[0].url.get_text(), 'http://example1.com')
        self.assertEquals(self.root.menu.items.get_children()[1].name.get_text(), u'Пункт 2')

    def test_iter(self):
        result = []
        for item in self.root.menu.items:
            result.append(item.name.get_text())
        self.assertEquals(result, [u'Пункт 1', u'Пункт 2'])

    def test_spec_symbols(self):
        self.assertEquals(self.root.spec_sy_mbols.get_text(), u'Символы')


if __name__ == '__main__':
    unittest.main()