#   Copyright 2013 UnitedStack
#
#   Licensed under the Apache License, Version 2.0 (the "License"); you may
#   not use this file except in compliance with the License. You may obtain
#   a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#   WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#   License for the specific language governing permissions and limitations
#   under the License.
#

"""Floating IP action implementations"""

import logging

from cliff import command
from cliff import lister
from cliff import show

from uos.cli.common import utils


class ListFloatingIP(lister.Lister):
    """List floating-ip command"""

    log = logging.getLogger(__name__ + '.ListFloatingIP')

    def take_action(self, parsed_args):
        self.log.debug('take_action(%s)' % parsed_args)
        network_client = self.app.client_manager.network

        columns = ('ID', 'Floating Ip Address', 'Fixed IP Address',
                   'Floating Network Id', 'Port Id', 'Status')

        data = network_client.list_floatingips()

        return (columns,
                (utils.get_dict_properties(
                    s, columns,
                    formatters={},
                ) for s in data['floatingips']))


class DeleteFloatingIP(command.Command):
    """Delete floating-ip command"""

    log = logging.getLogger(__name__ + '.DeleteFloatingIP')

    def get_parser(self, prog_name):
        parser = super(DeleteFloatingIP, self).get_parser(prog_name)
        parser.add_argument(
            "ip_address",
            metavar="<floatingip-id>",
            help="floatingip id to delete",
        )
        return parser

    def take_action(self, parsed_args):
        self.log.debug('take_action(%s)' % parsed_args)
        network_client = self.app.client_manager.network

        network_client.delete_floatingip(parsed_args.ip_address)
        return


class CreateFloatingIP(show.ShowOne):
    """Create floating-ip command"""

    log = logging.getLogger(__name__ + '.CreateFloatingIP')

    def get_parser(self, prog_name):
        parser = super(CreateFloatingIP, self).get_parser(prog_name)
        return parser

    def take_action(self, parsed_args):
        self.log.debug('take_action(%s)' % parsed_args)
        network_client = self.app.client_manager.network

        # TODO(yejia) body?
        network_client.create_floatingip()
        return
