#   Copyright 2013 UnitedStack
#
#   Licensed under the Apache License, Version 2.0 (the "License"); you may
#   not use this file except in compliance with the License. You may obtain
#   a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#   WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#   License for the specific language governing permissions and limitations
#   under the License.
#

"""Port IP action implementations"""

import logging

from cliff import command
from cliff import lister

from uos.cli.common import utils


class ListPort(lister.Lister):
    """ List Port command"""

    log = logging.getLogger(__name__ + '.ListPort')

    def take_action(self, parsed_args):
        self.log.debug('take_action(%s)' % parsed_args)
        network_client = self.app.client_manager.network

        columns = ('ID', 'Mac Address', 'Name', 'Status', 'Network Id',
                   'Device Owner', 'Device Id',)

        data = network_client.list_ports()

        return (columns,
                (utils.get_dict_properties(
                    s, columns,
                    formatters={},
                ) for s in data['ports']))
