#   Copyright 2013 UnitedStack
#
#   Licensed under the Apache License, Version 2.0 (the "License"); you may
#   not use this file except in compliance with the License. You may obtain
#   a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#   WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#   License for the specific language governing permissions and limitations
#   under the License.
#

"""Network IP action implementations"""

from neutronclient.neutron.v2_0 import network


class ListNetwork(network.ListNetwork):
    """List Network command"""

    list_columns = ['id', 'name', 'subnets', 'router:external',
                    'uos:rate_limit', 'created_at']


class ListExternalNetwork(network.ListExternalNetwork):
    """List External network"""
    list_columns = ['id', 'name', 'subnets', 'router:external',
                    'uos:rate_limit', 'created_at']


class ShowNetwork(network.ShowNetwork):
    """Show network command"""


class CreateNetwork(network.CreateNetwork):
    """Create network command"""


class DeleteNetwork(network.DeleteNetwork):
    """Delete network command"""


class UpdateNetwork(network.DeleteNetwork):
    """Update network command"""
