#   Copyright 2013 UnitedStack
#
#   Licensed under the Apache License, Version 2.0 (the "License"); you may
#   not use this file except in compliance with the License. You may obtain
#   a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#   WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#   License for the specific language governing permissions and limitations
#   under the License.
#

from neutronclient.neutron.v2_0 import subnet


class ListSubnet(subnet.ListSubnet):
    """ List Subnet command"""

    list_columns = ['id', 'name', 'shared', 'gateway_ip',
                    'enable_dhcp', 'dns_nameservers',
                    'cidr', 'allocation_pools']


class ShowSubnet(subnet.ListSubnet):
    """Show Subnet command"""


class DeleteSubnet(subnet.DeleteSubnet):
    """Delete Subnet command"""


class CreateSubnet(subnet.CreateSubnet):
    """Create Subnet command"""


class UpdateSubnet(subnet.UpdateSubnet):
    """Update Subnet comand"""
