#   Copyright 2013 UnitedStack
#
#   Licensed under the Apache License, Version 2.0 (the "License"); you may
#   not use this file except in compliance with the License. You may obtain
#   a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#   WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#   License for the specific language governing permissions and limitations
#   under the License.
#

"""Security Group action implementations"""

from neutronclient.neutron.v2_0 import securitygroup


class ListSecurityGroup(securitygroup.ListSecurityGroup):
    """List security group command"""
    list_columns = ['id', 'name', 'description']


class ShowSecurityGroup(securitygroup.ListSecurityGroup):
    """Show sg command """


class CreateSecurityGroup(securitygroup.CreateSecurityGroup):
    """Create sg command """


class DeleteSecurityGroup(securitygroup.DeleteSecurityGroup):
    """Delete sg command """


class UpdateSecurityGroup(securitygroup.UpdateSecurityGroup):
    """Update sg command"""


class ListSecurityGroupRule(securitygroup.ListSecurityGroupRule):
    """List sg rule comand"""


class ShowSecurityGroupRule(securitygroup.ShowSecurityGroupRule):
    """Show sg rule command"""


class CreateSecurityGroupRule(securitygroup.CreateSecurityGroupRule):
    """Create sg rule command"""


class DeleteSecurityGroupRule(securitygroup.DeleteSecurityGroupRule):
    """Delete sg rule command"""
