#   Copyright 2013 UnitedStack
#
#   Licensed under the Apache License, Version 2.0 (the "License"); you may
#   not use this file except in compliance with the License. You may obtain
#   a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#   WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#   License for the specific language governing permissions and limitations
#   under the License.
#

"""Floating IP action implementations"""

from neutronclient.neutron.v2_0 import floatingip


class ListFloatingIP(floatingip.ListFloatingIP):
    """List floating-ip command"""

    list_columns = ['id', 'fixed_ip_address', 'floating_ip_address',
                    'floating_network_id', 'port_id', 'status']


class ShowFloatingIP(floatingip.ShowFloatingIP):
    """ Show Floating ip command"""


class CreateFloatingIP(floatingip.CreateFloatingIP):
    """ Create Floating ip command"""


class DeleteFloatingIP(floatingip.DeleteFloatingIP):
    """Delete Floating ip command"""


class AssociateFloatingIP(floatingip.AssociateFloatingIP):
    """Associate Floating ip command"""


class DisassociateFloatingIP(floatingip.DisassociateFloatingIP):
    """Disassociate Floating ip command"""
