#   Copyright 2013 UnitedStack
#
#   Licensed under the Apache License, Version 2.0 (the "License"); you may
#   not use this file except in compliance with the License. You may obtain
#   a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#   WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#   License for the specific language governing permissions and limitations
#   under the License.
#

"""Port IP action implementations"""

from neutronclient.neutron.v2_0 import port


class ListPort(port.ListPort):
    """List Port command"""

    list_columns = ['id', 'name', 'mac_address', 'fixed_ips',
                    'status', 'network_id', 'device_owner',
                    'device_id']


class ListRouterPort(port.ListRouterPort):
    """List Router Port command"""
    list_columns = ['id', 'name', 'mac_address', 'fixed_ips',
                    'status', 'network_id', 'device_owner',
                    'device_id']


class ShowPort(port.ShowPort):
    """Show Port command"""


class CreatePort(port.CreatePort):
    """Create Port command"""


class DeletePort(port.DeletePort):
    """Delete Port command"""


class UpdatePort(port.UpdatePort):
    """Update Port command"""
