#   Copyright 2013 UnitedStack
#
#   Licensed under the Apache License, Version 2.0 (the "License"); you may
#   not use this file except in compliance with the License. You may obtain
#   a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#   WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#   License for the specific language governing permissions and limitations
#   under the License.
#

"""Router IP action implementations"""

from neutronclient.neutron.v2_0 import router


class ListRouter(router.ListRouter):
    """ List Router command"""

    list_columns = ['id', 'name', 'external_gateway_info', 'status']


class ShowRouter(router.ShowRouter):
    """Show Router command"""


class CreateRouter(router.CreateRouter):
    """Create Router command"""


class DeleteRouter(router.DeleteRouter):
    """Delete Router command"""


class UpdateRouter(router.UpdateRouter):
    """Update Router command"""


class AddInterfaceRouter(router.AddInterfaceRouter):
    """Add Interface command"""


class RemoveInterfaceRouter(router.RemoveInterfaceRouter):
    """Remove Interface command"""


class SetGatewayRouter(router.SetGatewayRouter):
    """Set Gateway command"""


class RemoveGatewayRouter(router.RemoveGatewayRouter):
    """Remove Gateway command"""
