#   Copyright 2012-2013 UnitedStack
#
#   Licensed under the Apache License, Version 2.0 (the "License"); you may
#   not use this file except in compliance with the License. You may obtain
#   a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#   WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#   License for the specific language governing permissions and limitations
#   under the License.
#


import logging

from uos.cli.common import utils


LOG = logging.getLogger(__name__)


DEFAULT_NETWORK_API_VERSION = '2.0'
API_VERSION_OPTION = 'os_network_api_version'
API_NAME = "network"
API_VERSIONS = {
    "2.0": "neutronclient.v2_0.client.Client",
}


def make_client(instance):
    """Return an network service client."""
    network_client = utils.get_client_class(
        API_NAME,
        instance._api_version[API_NAME],
        API_VERSIONS)

    LOG.debug('instantiating network client: %s' % network_client)

    if not instance._url:
        instance._url = instance.get_endpoint_for_service_type(API_NAME)

    return network_client(
        token=instance._token,
        ca_cert=instance._cacert,
        insecure=instance._insecure,
        endpoint_url=instance._url,
    )


def build_option_parser(parser):
    """Hook to add global options"""
    parser.add_argument(
        '--os-network-api-version',
        metavar='<network-api-version>',
        default=utils.env(
            'OS_NETWORK_API_VERSION',
            default=DEFAULT_NETWORK_API_VERSION),
        help='Volume API version, default=' +
             DEFAULT_NETWORK_API_VERSION +
             ' (Env: OS_NETWORK_API_VERSION)')
    return parser
