# RFC 3986 2.2: gen-delims = ":" / "/" / "?" / "#" / "[" / "]" / "@"
GEN_DELIMS = ':/?#[]@'

# RFC 3986 2.2: sub-delims = "!" / "$" / "&" / "'" / "(" / ")"
#                          / "*" / "+" / "," / ";" / "="
SUB_DELIMS = "!$&'()*+,;="

# RFC 3986 2.2: reserved = gen-delims / sub-delims
RESERVED = GEN_DELIMS + SUB_DELIMS

# RFC 3986 2.3: unreserved = ALPHA / DIGIT / "-" / "." / "_" / "~"
UNRESERVED = (
    'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
    'abcdefghijklmnopqrstuvwxyz'
    '0123456789'
    '_.-~'
)
