"""Useful Script

Usage:
  useful.py new db <name> [<username> [<password> | --generate]] [-D] [-C]
  useful.py new www <name> [(--user=user --group=group)] [--base=base] [--template=template] [--reload | --restart] [-D] [-C]
  useful.py new user <name> [--home=home] [-D] [-C]
  useful.py untar <source> [--download] [<destination>] [-D] [-C]

Options:
  --dry, -D        Display the commands on stdout, instead of executing them
  --context, -C    Display the current context when running the command
  -d, --download   Treat the source as a url

To Do:
  * Implement command runners so they do something useful.
  * As with MySQLManagementRunner, create specific command runners which extend
    the bash command runner.
"""
from docopt import docopt
import os
import sys

from helpers import *
import runners

def handle():
  arguments = docopt(__doc__, version='useful.py 0.1.1')
  
  if arguments['db']:
    runner = runners.MySQLManagementRunner(arguments['--dry'])

    if arguments['new']:
      runner.create_database(arguments['<name>'])
      if arguments['<username>']:
        if arguments['--generate']:
          password = random_string()
        else:
          password = arguments['<password>']
        runner.create_user(arguments['<username>'], password)
        runner.grant_privileges(arguments['<name>'], arguments['<username>'])
      runner.flush_privileges()
      runner.display("Username: \"%s\" | Password: \"%s\"" % (arguments['<username>'], password))

  if arguments['user']:
    runner = runners.BashRunner(arguments['--dry'])

    if arguments['new']:
      extra = " --home=\"%s\"" % arguments['--home'] if arguments['--home'] else ''
      runner.execute('adduser %s%s' % (arguments['<name>'], extra), requires_root=True)

  if arguments['www']:
    runner = runners.BashRunner(arguments['--dry'])

    if arguments['new']:
      name = arguments['<name>']
      if arguments['--base']:
        path = os.path.join(arguments['--base'], name)
      else:
        path = os.path.join('/srv', name)
      runner.execute('mkdir "%s"' % path, requires_root=True)

      if arguments['--user']:
        runner.execute('chown %s:%s "%s"' % (arguments['--user'], arguments['--group'], path), requires_root=True)

      if arguments['--template']:
        raise NotImplemented('Templates are not available yet')

      if arguments['--restart'] or arguments['--reload']:
        raise NotImplemented('Apache runner not yet available')

  if arguments['untar']:
    runner = runners.BashRunner(arguments['--dry'])

    destination = or_blank_string(arguments['<destination>'])

    if arguments['--download']:
      import tempfile
      tempname = tempfile.NamedTemporaryFile().name
      runner.execute('wget %s -o %s' % (arguments['<source>'], tempname))

      source = tempname
    else:
      source = arguments['<source>']

    runner.execute('tar zxf "%s" %s' % (source, destination))

  if arguments['--context']:
    print arguments