from usefulpy import runners, logic
from usefulpy.helpers import *

class NewDatabase(logic.BaseCommand):
  signature = "new db <name> [<username> [<password> | --generate]] [-D]"

  def is_valid(self):
    return self.arguments['new'] and self.arguments['db']

  def run(self):
    runner = runners.MySQLManagementRunner(self.arguments['--dry'])

    runner.create_database(self.arguments['<name>'])
    if self.arguments['<username>']:
      if self.arguments['--generate']:
        password = random_string()
      else:
        password = self.arguments['<password>']
      runner.create_user(self.arguments['<username>'], password)
      runner.grant_privileges(self.arguments['<name>'], self.arguments['<username>'])
      runner.flush_privileges()
      runner.display("Username: \"%s\" | Password: \"%s\"" % (self.arguments['<username>'], password))