from usefulpy import runners, logic
from usefulpy.helpers import *

class NewUser(logic.BaseCommand):
  signature = "new user <name> [--home=home] [-D]"

  def is_valid(self):
    return self.arguments['new'] and self.arguments['user']

  def run(self):
    runner = runners.BashRunner(self.arguments['--dry'])

    extra = " --home=\"%s\"" % self.arguments['--home'] if self.arguments['--home'] else ''
    runner.execute('adduser %s%s' % (self.arguments['<name>'], extra), requires_root=True)
