from usefulpy import runners, logic
from usefulpy.helpers import *

import os

class NewWWW(logic.BaseCommand):
  signature = "new www <name> [(--user=user --group=group)] [--base=base] [--template=template] [--reload | --restart] [-D]"
  def is_valid(self):
    return self.arguments['new'] and self.arguments['www']

  def run(self):
    runner = runners.BashRunner(self.arguments['--dry'])

    if self.arguments['new']:
      name = self.arguments['<name>']
      if self.arguments['--base']:
        path = os.path.join(self.arguments['--base'], name)
      else:
        path = os.path.join('/srv', name)
      runner.execute('mkdir "%s"' % path, requires_root=True)

      if self.arguments['--user']:
        runner.execute('chown %s:%s "%s"' % (self.arguments['--user'], self.arguments['--group'], path), requires_root=True)

      if self.arguments['--template']:
        raise NotImplemented('Templates are not available yet')

      if self.arguments['--restart'] or self.arguments['--reload']:
        raise NotImplemented('Apache runner not yet available')