from usefulpy import runners, logic
from usefulpy.helpers import *

class Untar(logic.BaseCommand):
  signature = "untar <source> [--download] [<destination>] [-D]"

  def is_valid(self):
    return self.arguments['untar']

  def run(self):
    runner = runners.BashRunner(self.arguments['--dry'])
    destination = or_blank_string(self.arguments['<destination>'])

    if self.arguments['--download']:
      import tempfile
      tempname = tempfile.NamedTemporaryFile().name
      runner.execute('wget %s -o %s' % (self.arguments['<source>'], tempname))

      source = tempname
    else:
      source = self.arguments['<source>']

    runner.execute('tar zxf "%s" %s' % (source, destination))