from usefulpy.helpers import *

class CommandRunner(object):
  dry = False

  def __init__(self, dry=None):
    self.dry = dry

  def execute(self, command, *args, **kwargs):
    if self.dry:
      print command
    else:
      result = self.handle(command, *args, **kwargs)
      if result not in [0, None, True]:
        print "An error occurred, the command returned %s" % result

  def handle(self, *args, **kwargs):
    raise NotImplemented("Runner has not implemented method \"handle\"")

  def display(self, obj):
    print " > %s" % obj

class BaseMySQLRunner(CommandRunner):
  def handle(self, command):
    print '*** DO ***', command
    return 0

class BashRunner(CommandRunner):
  def handle(self, command, requires_root=False):
    if requires_root:
      print '*** DO *** sudo', command
    else:
      print '*** DO ***', command
    return 0

class MySQLManagementRunner(BaseMySQLRunner):
  def create_database(self, database_name):
    self.execute('CREATE DATABASE `%s`;' % database_name)

  def create_user(self, username, password):
    self.execute("CREATE USER '%s'@'127.0.0.1' IDENTIFIED BY '%s';" % (username, password))

  def grant_privileges(self, database, username, privileges="ALL PRIVILEGES"):
    self.execute("GRANT %s ON `%s`.* TO '%s'@'127.0.0.1';" % (privileges, database, username))

  def flush_privileges(self):
    self.execute("FLUSH PRIVILEGES;")

  def password(self, password, generate):
    if generate:
      return random_string()
    else:
      return password