from usefulpy import runners, logic
from usefulpy.helpers import *

class NewDatabase(logic.BaseCommand):
  """
  Usage:
    useful.py db new <name> [<username> [<password> | --generate]] [-D]

  Options:
    -D, --dry    Print the commands to stdout
    --generate   Generate a pseudo-random password
  """

  def run(self):
    runner = runners.MySQLManagementRunner(self.arguments['--dry'])

    runner.create_database(self.arguments['<name>'])
    if self.arguments['<username>']:
      password = runner.password(self.arguments['<username>'], self.arguments['--generate'])
      runner.create_user(self.arguments['<username>'], password)
      runner.grant_privileges(self.arguments['<name>'], self.arguments['<username>'])
      runner.flush_privileges()
      runner.display("Username: \"%s\" | Password: \"%s\"" % (self.arguments['<username>'], password))

class NewUser(logic.BaseCommand):
  """
  Usage:
    useful.py db new user <username> [<password> | --generate] [-D]

  Options:
    -D, --dry    Print the commands to stdout
    --generate   Generate a pseudo-random password
  """

  def run(self):
    runner = runners.MySQLManagementRunner(self.arguments['--dry'])
    password = runner.password(self.arguments['<password>'], self.arguments['--generate'])
    runner.create_user(self.arguments['<username>'], password)

class GrantPrivileges(logic.BaseCommand):
  """
  Usage:
    db grant <database> <username> [-D]

  Options:
    -D, --dry    Print the commands to stdout
  """

  def run(self):
    runner = runners.MySQLManagementRunner(self.arguments['--dry'])

    runner.grant_privileges(self.arguments['<database>'], self.arguments['<username>'])
    runner.flush_privileges()