import subprocess, shlex, os

from usefulpy.helpers import *
from usefulpy.exceptions import NeedsRoot, CommandError

class CommandRunner(object):
  dry = False

  def __init__(self, dry=None):
    self.dry = dry

  def execute(self, command, *args, **kwargs):
    if self.dry:
      print command
    else:
      result = self.handle(command, *args, **kwargs)

  def handle(self, *args, **kwargs):
    raise NotImplemented("Runner has not implemented method \"handle\"")

  def display(self, obj):
    print " > %s" % obj

class BaseMySQLRunner(CommandRunner):

  def __init__(self, *args, **kwargs):
    self.get_details()
    self.bash = BashRunner()
    super(BaseMySQLRunner, self).__init__(*args, **kwargs)

  def get_details(self):
    import ConfigParser
    cp = ConfigParser.ConfigParser()
    cp.readfp(open('/etc/mysql/debian.cnf'))
    self._username = cp.get('client', 'user')
    self._password = cp.get('client', 'password')

  def handle(self, command):
    return self.bash.handle("mysql -u%s -p%s -e '%s'" % (self._username, self._password, command))

class BashRunner(CommandRunner):
  cwd = None

  def handle(self, command, requires_root=False, shell=False):
    if requires_root and os.getuid() != 0:
      raise NeedsRoot()
    if type(command) == str:
      command = shlex.split(command)

    process = subprocess.Popen(command, shell, stdout=subprocess.PIPE, stderr=subprocess.PIPE, cwd=self.cwd)
    stdout, stderr = process.communicate()
    process.poll()

    print process.returncode
    print stderr or stdout

    if process.returncode != 0:
      raise CommandError(stderr or stdout)
    return stdout

  def cd(self, directory=None):
    self.cwd = directory

class MySQLManagementRunner(BaseMySQLRunner):
  def create_database(self, database_name):
    self.execute('CREATE DATABASE `%s`;' % database_name)

  def create_user(self, username, password):
    self.execute("CREATE USER '%s'@'127.0.0.1' IDENTIFIED BY '%s';" % (username, password))

  def grant_privileges(self, database, username, privileges="ALL PRIVILEGES"):
    self.execute("GRANT %s ON `%s`.* TO '%s'@'127.0.0.1';" % (privileges, database, username))

  def flush_privileges(self):
    self.execute("FLUSH PRIVILEGES;")

  def password(self, password, generate):
    if generate:
      return random_string()
    else:
      return password