#!/usr/bin/env python3
from setuptools import setup
import os

icon_files = []
for element in os.listdir('icons'):
	if element.endswith('.svg'):
		icon_files.append('icons/%s' % element)

setup(name='uwz',
	version='1.0.0',
	description='Get Wheather warnings for Europe from the Unwetterzentrale',
	author='Nils Martin Klünder',
	author_email='nomoketo@nomoketo.de',
	url='https://github.com/NoMoKeTo/python-uwz',
	py_modules=['uwz'],
	license='MIT',
	entry_points={
		'console_scripts': [
			'uwztray = uwz:Tray'
		]
	},
	classifiers=[
		'Topic :: Software Development :: Libraries :: Python Modules', 
		'Intended Audience :: Developers',
		'Intended Audience :: End Users/Desktop',
		'License :: OSI Approved :: MIT License'],
	data_files=[('/usr/share/uwz/icons/', icon_files)],
	install_requires=['beautifulsoup4', 'pygobject'],
	)
