#!/usr/bin/env python3
from setuptools import setup
import os

setup(name='uwz',
	version='1.0.4',
	description='Get Wheather warnings for Europe from the Unwetterzentrale',
	author='Nils Martin Klünder',
	author_email='nomoketo@nomoketo.de',
	url='https://github.com/NoMoKeTo/python-uwz',
	py_modules=['uwz'],
	license='MIT',
	entry_points={
		'console_scripts': [
			'uwztray = uwz:Tray'
		]
	},
	classifiers=[
		'Topic :: Software Development :: Libraries :: Python Modules', 
		'Intended Audience :: Developers',
		'Intended Audience :: End Users/Desktop',
		'License :: OSI Approved :: MIT License'],
	data_files=[('/usr/share/uwz/icons/', ['icons/*.svg'])],
	install_requires=['beautifulsoup4', 'pygobject', 'geolocate', 'geopy'],
	)
