#!/usr/bin/env python3
from setuptools import setup
import os

setup(name='uwz',
	version='1.1.1',
	description='Get Wheather warnings for Europe from the Unwetterzentrale',
	author='Nils Martin Klünder',
	author_email='nomoketo@nomoketo.de',
	url='https://github.com/NoMoKeTo/python-uwz',
	py_modules=['uwz'],
	license='MIT',
	entry_points={
		'console_scripts': [
			'uwztray = uwz:Tray'
		]
	},
	classifiers=[
		'Topic :: Software Development :: Libraries :: Python Modules', 
		'Intended Audience :: Developers',
		'Intended Audience :: End Users/Desktop',
		'License :: OSI Approved :: MIT License'],
	data_files=[('/usr/share/uwz/icons/', ['icons/warnings-13.svg', 'icons/warnings-24.svg', 'icons/warnings-33.svg', 'icons/warnings-04.svg', 'icons/warnings-35.svg', 'icons/warnings-38.svg', 'icons/warnings-23.svg', 'icons/warnings-error.svg', 'icons/warnings-12.svg', 'icons/warnings-0.svg', 'icons/warnings-08.svg', 'icons/warnings-09.svg', 'icons/warnings-17.svg', 'icons/warnings-03.svg', 'icons/warnings-19.svg', 'icons/warnings-31.svg', 'icons/warnings-36.svg', 'icons/warnings-06.svg', 'icons/warnings-26.svg', 'icons/warnings-15.svg', 'icons/warnings-1.svg', 'icons/warnings-28.svg', 'icons/warnings-34.svg', 'icons/warnings-25.svg', 'icons/warnings-29.svg', 'icons/warnings-39.svg', 'icons/warnings-21.svg', 'icons/warnings-32.svg', 'icons/warnings-02.svg', 'icons/warnings-2.svg', 'icons/warnings-16.svg', 'icons/warnings-27.svg', 'icons/warnings-37.svg', 'icons/warnings-14.svg', 'icons/warnings-01.svg', 'icons/warnings-18.svg', 'icons/warnings-05.svg', 'icons/warnings-07.svg', 'icons/warnings-11.svg', 'icons/warnings-22.svg'])],
	install_requires=['beautifulsoup4', 'pygobject', 'geolocate', 'geopy'],
	)
