#!/usr/bin/env python
import subprocess

def testDebugReport():
    """
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/ALG10B.genes -p test/test_data/params/debug.yaml --no-debug --data_basedir=./test/test_data -w 50 -t values_by_node"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> print output[:500] #doctest: +NORMALIZE_WHITESPACE 
    genotype name window whole_gene_nsnps network_gene network_continent network_distance_definition n_datapoints cont_str degree closeness betweenness
    00100000000001000000000001000000001001000000000000  ALG10B  window_0    67  ALG10B  glob    1   572 afr_no_AMR_ASN_AFR_EUR  6   0.0213  15.0
    10100000010000000101010000010000001000001101010001  ALG10B  window_0    67  ALG10B  glob    1   390 afr_no_AMR_ASN_AFR_EUR  2   0.0208  4.0
    00100000010000000101000000000001001000000001010001  ALG10B  window_0    67  ALG10B  glob    1   247 afr_no_AMR_ASN_

    """
def testDebugReportHDF5():
    """
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/ALG10B.genes -p test/test_data/params/debug.yaml --no-debug --data_basedir=./test/test_data -w 50 -t values_by_node --hdf5"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> print output[:500] #doctest: +NORMALIZE_WHITESPACE 
    genotype name window whole_gene_nsnps network_gene network_continent network_distance_definition n_datapoints cont_str degree closeness betweenness
    00100000000001000000000001000000001001000000000000  ALG10B  window_0    67  ALG10B  glob    1   572 afr_no_AMR_ASN_AFR_EUR  6   0.0213  15.0
    10100000010000000101010000010000001000001101010001  ALG10B  window_0    67  ALG10B  glob    1   390 afr_no_AMR_ASN_AFR_EUR  2   0.0208  4.0
    00100000010000000101000000000001001000000001010001  ALG10B  window_0    67  ALG10B  glob    1   247 afr_no_AMR_ASN_
    """

def testDebugReportDistance2():
    """
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/ALG10B.genes -p test/test_data/params/debug.yaml --no-debug --distance 2 --data_basedir=./test/test_data --windows_size 50 -t values_by_node"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> print output[:500] #doctest: +NORMALIZE_WHITESPACE
    genotype name window whole_gene_nsnps network_gene network_continent network_distance_definition n_datapoints cont_str degree closeness betweenness
    00100000000001000000000001000000001001000000000000  ALG10B  window_0    67  ALG10B  glob    2   572 afr_no_AMR_ASN_AFR_EUR  6   0.0222  0.0
    10100000010000000101010000010000001000001101010001  ALG10B  window_0    67  ALG10B  glob    2   390 afr_no_AMR_ASN_AFR_EUR  7   0.0227  24.5
    00100000010000000101000000000001001000000001010001  ALG10B  window_0    67  ALG10B  glob    2   247 afr_no_AMR_ASN_
    """

def testDebugReportSmallWindow():
    """
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/ALG10B.genes -p test/test_data/params/debug.yaml --no-debug --distance 2 --data_basedir=./test/test_data --windows_size 5 -t values_by_node"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> print output[:500] #doctest: +NORMALIZE_WHITESPACE
    genotype name window whole_gene_nsnps network_gene network_continent network_distance_definition n_datapoints cont_str degree closeness betweenness
    00110   ALG10B  window_0    67  ALG10B  glob    2   597 afr_no_AMR_ASN_AFR_EUR  4   0.7 0.3333
    10010   ALG10B  window_0    67  ALG10B  glob    2   1079    afr_no_AMR_ASN_AFR_EUR  7   1.0 4.6667
    00000   ALG10B  window_0    67  ALG10B  glob    2   84  AMR_afr_no_AFR_EUR  3   0.6364  0.0
    11010   ALG10B  window_0    67  ALG10B  glob    2   338 afr_no_AMR_ASN_AFR_EUR  5   0.7778  0.6667
    11011   ALG10B  window_0    67  ALG10B  glob    
    """
def testFullReport():
    """
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/ALG10B.genes -p params/default.yaml --no-debug --data_basedir=./test/test_data --windows_size 50 -t values_by_node"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    >>> print output[:500] #doctest: +NORMALIZE_WHITESPACE
    genotype name window whole_gene_nsnps network_gene network_continent network_distance_definition cont_str n_datapoints degree closeness betweenness
    00100000000001000000000001000000001001000000000000  ALG10B  window_0    67  ALG10B  glob    1   afr_no_AMR_ASN_AFR_EUR  572 6   0.0213  15.0
    10100000010000000101010000010000001000001101010001  ALG10B  window_0    67  ALG10B  glob    1   afr_no_AMR_ASN_AFR_EUR  390 2   0.0208  4.0
    00100000010000000101000000000001001000000001010001  ALG10B  window_0    67  ALG10B  glob    1   afr_no_AMR_ASN_AFR_

"""

def testDebugReportOverlapping():
    """
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/ALG10B.genes -p test/test_data/params/debug.yaml --no-debug --data_basedir=./test/test_data -w 50 -t values_by_node -l"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> print output[:500] #doctest: +NORMALIZE_WHITESPACE 
    genotype name window whole_gene_nsnps network_gene network_continent network_distance_definition n_datapoints cont_str degree closeness betweenness
    00011000001000000000010000000000010000000010010000  ALG10B  window_0    67  ALG10B  glob    1   572 afr_no_AMR_ASN_AFR_EUR  6   0.0227  15.0
    01001010101000000100000001010100000100000010000011  ALG10B  window_0    67  ALG10B  glob    1   390 afr_no_AMR_ASN_AFR_EUR  2   0.0217  3.0
    01001010001000000100000001010000000000010010000000  ALG10B  window_0    67  ALG10B  glob    1   247 afr_no_AMR_ASN_
"""


