#!/usr/bin/env python
import subprocess
import operator
import random

def testDebugReportIndividualSubsampling():
    """
    Check that the individuals subsampled are always the same.

    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --data_basedir=./test/test_data --random_seed 2 -n 50 -t individuals_line"

    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> output_lines = output.split('\\n')

    >>> for line in output_lines: #doctest: +NORMALIZE_WHITESPACE 
    ...     print line[0:60]
    <BLANKLINE>
    -----ALG10B AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA184
    -----ALG10B AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA184
    -----ALG10B AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA184
    -----CCR5 AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA18489
    <BLANKLINE>

    >>> output_lines = output_lines[1:-1]
    >>> output_fields = [line.split() for line in output_lines]

    # Check that all the columns, except for the ones starting with "--", have the same values for all the output lines.
    # This means that all the selected individuals are the same, for each line.

    # Select 500 random columns:
    >>> random_columns = random.sample(xrange(len(output_fields[0])), 500)
    >>> fields_getter = operator.itemgetter(*random_columns)
    >>> ALG3_columns = fields_getter(output_fields[0])
    >>> ALG10B_columns = fields_getter(output_fields[1])
    >>> CCR5_columns = fields_getter(output_fields[2])
    >>> for column_id in xrange(len(ALG3_columns)):
    ...     if not ALG3_columns[column_id].startswith("----"):
    ...        if not ALG3_columns[column_id] == ALG10B_columns[column_id] == CCR5_columns[column_id]:
    ...             print "not matching values", ALG3_columns[column_id], ALG10B_columns[column_id], CCR5_columns[column_id]
    """

def testDebugReportIndividualSubsamplingReplicates():
    """
    Check that the individuals subsampled are always the same.

    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --data_basedir=./test/test_data --random_seed 2 -n 50 -t individuals_line -s 5"

    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> output_lines = output.split('\\n')

    >>> for line in output_lines: #doctest: +NORMALIZE_WHITESPACE 
    ...     print line[0:60]
   <BLANKLINE>
    -----ALG3 AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA18489
    -----ALG3 AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA18489
    -----ALG3 AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA18489
    -----ALG3 AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA18489
    -----ALG3 AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA18489
    -----ALG10B AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA184
    -----ALG10B AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA184
    -----ALG10B AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA184
    -----ALG10B AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA184
    -----ALG10B AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA184
    -----CCR5 AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA18489
    -----CCR5 AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA18489
    -----CCR5 AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA18489
    -----CCR5 AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA18489
    -----CCR5 AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA18489
    <BLANKLINE>

    >>> output_lines = output_lines[1:-1]
    >>> output_fields = [line.split() for line in output_lines]


    # Check that all the columns, except for the ones starting with "--", have the same values for all the output lines.
    # This means that all the selected individuals are the same, for each line.
    >>> random_columns = random.sample(xrange(len(output_fields[0])), 500)
    >>> fields_getter = operator.itemgetter(*random_columns)
    >>> for replica_id in range(5):
    ...     ALG3_columns = fields_getter(output_fields[replica_id])
    ...     ALG10B_columns = fields_getter(output_fields[replica_id+5])
    ...     CCR5_columns = fields_getter(output_fields[replica_id+10])
    ...     for column_id in xrange(len(ALG3_columns)):
    ...         if not ALG3_columns[column_id].startswith("----"):
    ...             if not ALG3_columns[column_id] == ALG10B_columns[column_id] == CCR5_columns[column_id]:
    ...                 print "not matching values", ALG3_columns[column_id], ALG10B_columns[column_id], CCR5_columns[column_id]

  
    """

def testDebugReportIndividualSubsamplingMultipleWindows():
    """
    Check that the individuals subsampled are always the same.

    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --data_basedir=./test/test_data --random_seed 2 -n 50 -t individuals_line -w 20"

    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> output_lines = output.split('\\n')

    >>> for line in output_lines: #doctest: +NORMALIZE_WHITESPACE 
    ...     print line[0:60]
    <BLANKLINE>
    -----ALG10B AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA184
    -----ALG10B AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA184
    -----ALG10B AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA184
    -----CCR5 AFR  NA18486_1 AFR YRI  NA18487_1 AFR YRI  NA18489
    <BLANKLINE>

    >>> output_lines = output_lines[1:-1]
    >>> output_fields = [line.split() for line in output_lines]

    # Check that all the columns, except for the ones starting with "--", have the same values for all the output lines.
    # This means that all the selected individuals are the same, for each line.

    # Select 500 random columns:
    >>> random_columns = random.sample(xrange(len(output_fields[0])), 500)
    >>> fields_getter = operator.itemgetter(*random_columns)
    >>> ALG10B_w1_columns = fields_getter(output_fields[0])
    >>> ALG10B_w2_columns = fields_getter(output_fields[1])
    >>> ALG10B_w3_columns = fields_getter(output_fields[2])
    >>> CCR5_columns = fields_getter(output_fields[3])
    >>> for column_id in xrange(len(ALG10B_w1_columns)):
    ...     if not ALG10B_w1_columns[column_id].startswith("----"):
    ...        if not ALG10B_w1_columns[column_id] == ALG10B_w2_columns[column_id] == ALG10B_w3_columns[column_id] == CCR5_columns[column_id]:
    ...             print "not matching values", ALG10B_w1_columns[column_id], ALG10B_w2_columns[column_id], ALG10B_w3_columns[column_id], CCR5_columns[column_id]
    """



if __name__ == '__main__':
    import logging
    import doctest
    logging.basicConfig(level=logging.DEBUG)
    doctest.testmod()


