#!/usr/bin/env python
import subprocess

def testDebugReport():
    """
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --data_basedir=./test/test_data --windows_size 25"
    >>> output_noHDF5 = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> print output_noHDF5 #doctest: +NORMALIZE_WHITESPACE 
    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    ALG10B 25 2184 glob 5 6 1.7241 window_0 67
    ALG10B 25 1700 global_noAMR 5 6 1.7037 window_0 67
    ALG10B 25 370 AFR 5 4 1.375 window_0 67
    ALG10B 25 572 ASN 3 3 1.3333 window_0 67
    ALG10B 25 758 EUR 4 3 1.6471 window_0 67
    ALG10B 25 2184 glob 7 5 1.5862 window_1 67
    ALG10B 25 1700 global_noAMR 7 4 1.4615 window_1 67
    ALG10B 25 370 AFR 7 4 1.2632 window_1 67
    ALG10B 25 572 ASN 4 2 1.0 window_1 67
    ALG10B 25 758 EUR 4 4 1.4667 window_1 67
    CCR5 25 2184 glob 7 8 1.8788 window_0 31
    CCR5 25 1700 global_noAMR 5 8 1.9259 window_0 31
    CCR5 25 370 AFR 4 3 1.3333 window_0 31
    CCR5 25 572 ASN 3 4 1.5385 window_0 31
    CCR5 25 758 EUR 4 4 1.7333 window_0 31
    <BLANKLINE>

    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --data_basedir=./test/test_data --windows_size 25 --hdf5"
    >>> output_HDF5 = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> print output_HDF5
    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    ALG10B 25 2184 glob 5 6 1.7241 window_0 67
    ALG10B 25 1700 global_noAMR 5 6 1.7037 window_0 67
    ALG10B 25 370 AFR 5 4 1.375 window_0 67
    ALG10B 25 572 ASN 3 3 1.3333 window_0 67
    ALG10B 25 758 EUR 4 3 1.6471 window_0 67
    ALG10B 25 2184 glob 7 5 1.5862 window_1 67
    ALG10B 25 1700 global_noAMR 7 4 1.4615 window_1 67
    ALG10B 25 370 AFR 7 4 1.2632 window_1 67
    ALG10B 25 572 ASN 4 2 1.0 window_1 67
    ALG10B 25 758 EUR 4 4 1.4667 window_1 67
    CCR5 25 2184 glob 7 8 1.8788 window_0 31
    CCR5 25 1700 global_noAMR 5 8 1.9259 window_0 31
    CCR5 25 370 AFR 4 3 1.3333 window_0 31
    CCR5 25 572 ASN 3 4 1.5385 window_0 31
    CCR5 25 758 EUR 4 4 1.7333 window_0 31
    <BLANKLINE>

    >>> output_noHDF5 == output_HDF5
    True



    """

def testDebugReportOverlapping():
    """
    Test the -l (overlapping windows) option. When this option is enabled, each window should start at the second position of the previous window.
    So, if the ALG10B gene has 67 SNPS, and we use window_size == 65 and -l == True, we should have three windows, starting at position 0, 1, and 2.

    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --data_basedir=./test/test_data --windows_size 65 -l"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> print output #doctest: +NORMALIZE_WHITESPACE 
    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    ALG10B 65 2184 glob 21 9 1.3846 window_0 67
    ALG10B 65 1700 global_noAMR 21 7 1.2364 window_0 67
    ALG10B 65 370 AFR 17 4 0.7857 window_0 67
    ALG10B 65 572 ASN 9 2 0.7143 window_0 67
    ALG10B 65 758 EUR 10 6 1.2857 window_0 67
    ALG10B 65 2184 glob 22 10 1.4366 window_1 67
    ALG10B 65 1700 global_noAMR 22 8 1.3115 window_1 67
    ALG10B 65 370 AFR 18 4 0.7143 window_1 67
    ALG10B 65 572 ASN 9 3 1.0588 window_1 67
    ALG10B 65 758 EUR 10 7 1.3548 window_1 67
    ALG10B 65 2184 glob 22 9 1.4286 window_2 67
    ALG10B 65 1700 global_noAMR 22 7 1.3 window_2 67
    ALG10B 65 370 AFR 18 4 0.7143 window_2 67
    ALG10B 65 572 ASN 9 3 1.0588 window_2 67
    ALG10B 65 758 EUR 10 6 1.3333 window_2 67
    <BLANKLINE>

    """
def testDebugReportDistance2():
    """
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --distance 2 --data_basedir=./test/test_data --windows_size 25"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> print output #doctest: +NORMALIZE_WHITESPACE
    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    ALG10B 25 2184 glob 4 14 5.1034 window_0 67
    ALG10B 25 1700 global_noAMR 4 13 4.6667 window_0 67
    ALG10B 25 370 AFR 4 7 3.0 window_0 67
    ALG10B 25 572 ASN 2 4 2.4444 window_0 67
    ALG10B 25 758 EUR 2 8 3.5294 window_0 67
    ALG10B 25 2184 glob 3 13 4.3448 window_1 67
    ALG10B 25 1700 global_noAMR 3 11 3.6154 window_1 67
    ALG10B 25 370 AFR 3 10 3.0526 window_1 67
    ALG10B 25 572 ASN 4 3 1.5 window_1 67
    ALG10B 25 758 EUR 3 7 3.2 window_1 67
    CCR5 25 2184 glob 3 13 5.697 window_0 31
    CCR5 25 1700 global_noAMR 3 13 5.9259 window_0 31
    CCR5 25 370 AFR 3 6 2.8333 window_0 31
    CCR5 25 572 ASN 3 6 3.3846 window_0 31
    CCR5 25 758 EUR 4 5 3.4667 window_0 31
    <BLANKLINE>


    """

def testDebugReportReadGraphml():
    """
    Test whether the ReportFile can correctly read graphml files.

    Note: I need to save the graphml files before running this test, be careful when debugging.

    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --write_graphml --data_basedir=./test/test_data"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --read_graphml_if_possible --data_basedir=./test/test_data --windows_size 25"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> print output #doctest: +NORMALIZE_WHITESPACE
    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    ALG10B 25 2184 glob 5 6 1.7241 window_0 67
    ALG10B 25 1700 global_noAMR 5 6 1.7037 window_0 67
    ALG10B 25 370 AFR 5 4 1.375 window_0 67
    ALG10B 25 572 ASN 3 3 1.3333 window_0 67
    ALG10B 25 758 EUR 4 3 1.6471 window_0 67
    ALG10B 25 2184 glob 7 5 1.5862 window_1 67
    ALG10B 25 1700 global_noAMR 7 4 1.4615 window_1 67
    ALG10B 25 370 AFR 7 4 1.2632 window_1 67
    ALG10B 25 572 ASN 4 2 1.0 window_1 67
    ALG10B 25 758 EUR 4 4 1.4667 window_1 67
    CCR5 25 2184 glob 7 8 1.8788 window_0 31
    CCR5 25 1700 global_noAMR 5 8 1.9259 window_0 31
    CCR5 25 370 AFR 4 3 1.3333 window_0 31
    CCR5 25 572 ASN 3 4 1.5385 window_0 31
    CCR5 25 758 EUR 4 4 1.7333 window_0 31
    <BLANKLINE>


    """
def testFullReport():
    """
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p params/default.yaml --no-debug --data_basedir=./test/test_data --windows_size 15"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> print output #doctest: +NORMALIZE_WHITESPACE
    gene continent distance_definition n_snps central_snp chromosome central_snp_position upstream_position downstream_position region_size distance_from_upstream_margin distance_from_downstream_margin n_datapoints av_datapoints_per_node n_vertices n_edges n_components av_path_length var_path_length diameter av_w_path_length av_w_path_length_inv av_degree var_degree median_degree max_degree av_w_degree av_w_degree_inv av_closeness var_closeness median_closeness max_closeness density av_betweenness var_betweenness median_betweenness max_betweenness window whole_gene_nsnps
    ALG3 glob 1 15 NA NA nan nan nan nan nan nan 2184 99.2727 22 22 3 3.0167 2.5207 7 0.5917 217.6912 2.0 1.4545 2.0 5 0.1957 1009.8819 0.0903 0.0006 0.1024 0.1141 0.0952 11.0 189.4226 5.0667 45.0333 window_0 16
    ALG3 global_noAMR 1 15 NA NA nan nan nan nan nan nan 1700 85.0 20 18 5 2.5976 1.6262 5 0.686 98.7069 1.8 1.76 1.0 5 0.2115 522.6159 0.0905 0.0008 0.1067 0.1166 0.0947 6.55 101.0368 0.0 30.8333 window_0 16
    ALG3 AFR 1 15 NA NA nan nan nan nan nan nan 370 24.6667 15 13 4 2.125 1.0353 4 0.2759 29.5148 1.7333 1.1289 1.0 4 0.111 189.3458 0.1073 0.0008 0.1239 0.1359 0.1238 3.0 17.5667 0.0 11.6667 window_0 16
    ALG3 ASN 1 15 NA NA nan nan nan nan nan nan 572 95.3333 6 4 2 1.3333 0.2667 2 0.5676 7.8253 1.3333 0.2222 1.0 2 0.2838 121.1376 0.2421 0.0 0.2381 0.25 0.2667 0.3333 0.2222 0.0 1.0 window_0 16
    ALG3 EUR 1 15 NA NA nan nan nan nan nan nan 758 84.2222 9 6 3 1.5833 0.447 3 0.6569 11.6248 1.3333 0.6667 1.0 3 0.2838 197.9591 0.1553 0.0003 0.16 0.1667 0.1667 0.7778 1.284 0.0 3.0 window_0 16
    ALG10B glob 1 15 NA NA nan nan nan nan nan nan 2184 136.5 16 13 5 1.8182 0.5909 3 0.3676 9.7354 1.625 1.1094 1.0 4 0.162 616.3647 0.0869 0.0004 0.0878 0.1087 0.1083 1.6875 11.0065 0.0 10.3333 window_0 67
    ALG10B global_noAMR 1 15 NA NA nan nan nan nan nan nan 1700 113.3333 15 12 5 1.8387 0.6065 3 0.3734 9.4574 1.6 1.1733 1.0 4 0.156 502.0984 0.096 0.0006 0.1157 0.1217 0.1143 1.7333 11.7067 0.0 10.3333 window_0 67
    ALG10B AFR 1 15 NA NA nan nan nan nan nan nan 370 37.0 10 5 5 1.375 0.2679 2 0.427 5.2525 1.0 0.6 1.0 3 0.1314 14.796 0.1203 0.0003 0.1111 0.1429 0.1111 0.3 0.81 0.0 3.0 window_0 67
    ALG10B ASN 1 15 NA NA nan nan nan nan nan nan 572 81.7143 7 5 2 1.8667 0.5524 3 0.8387 4.2217 1.4286 1.3878 1.0 4 0.3142 88.25 0.3399 0.0083 0.3529 0.4615 0.2381 1.8571 10.4082 0.0 9.0 window_0 67
    ALG10B EUR 1 15 NA NA nan nan nan nan nan nan 758 108.2857 7 4 3 1.4286 0.2857 2 0.6604 3.1032 1.1429 0.6939 1.0 3 0.2635 171.948 0.2026 0.0015 0.2308 0.25 0.1905 0.4286 1.102 0.0 3.0 window_0 67
    ALG10B glob 1 15 NA NA nan nan nan nan nan nan 2184 109.2 20 18 3 3.2026 2.1758 7 0.5956 34.282 1.8 2.66 1.5 8 0.1593 574.6269 0.1894 0.0028 0.2021 0.2639 0.0947 16.85 746.9775 0.75 115.5 window_1 67
    ALG10B global_noAMR 1 15 NA NA nan nan nan nan nan nan 1700 89.4737 19 16 4 2.7234 1.5571 6 0.4679 32.0025 1.6842 2.2161 1.0 7 0.1471 490.4478 0.1164 0.0013 0.1353 0.1538 0.0936 8.5263 260.5125 0.0 63.5 window_1 67
    ALG10B AFR 1 15 NA NA nan nan nan nan nan nan 370 33.6364 11 7 4 2.1364 1.0758 4 0.4778 12.2161 1.2727 1.1074 1.0 4 0.1354 34.357 0.1463 0.0015 0.1724 0.1887 0.1273 2.2727 16.0165 0.0 12.0 window_1 67
    ALG10B ASN 1 15 NA NA nan nan nan nan nan nan 572 95.3333 6 3 3 1.5 0.3 2 0.5245 4.2953 1.0 1.0 1.0 3 0.1748 33.6602 0.2582 0.0044 0.2941 0.3333 0.2 0.5 1.25 0.0 3.0 window_1 67
    ALG10B EUR 1 15 NA NA nan nan nan nan nan nan 758 58.3077 13 10 4 1.7619 0.7905 4 0.445 21.6576 1.5385 0.5562 2.0 3 0.1806 311.4667 0.1027 0.0002 0.0909 0.1224 0.1282 1.2308 3.4852 0.5 6.5 window_1 67
    ALG10B glob 1 15 NA NA nan nan nan nan nan nan 2184 128.4706 17 17 2 2.4149 0.9765 5 0.3991 17.7765 2.0 2.7059 2.0 8 0.1596 578.1569 0.1717 0.0026 0.1951 0.2286 0.125 7.8235 252.1519 0.8333 66.8333 window_2 67
    ALG10B global_noAMR 1 15 NA NA nan nan nan nan nan nan 1700 106.25 16 14 2 2.4198 0.9966 5 0.4915 17.6806 1.75 2.8125 1.0 8 0.1543 265.0721 0.1716 0.0025 0.1974 0.2308 0.1167 7.1875 228.6523 0.0 61.0 window_2 67
    ALG10B AFR 1 15 NA NA nan nan nan nan nan nan 370 26.4286 14 11 3 2.0625 0.5705 4 0.6854 22.4267 1.5714 2.5306 1.0 7 0.2263 85.0032 0.147 0.0019 0.1733 0.194 0.1209 3.6429 78.5153 0.0 34.0 window_2 67
    ALG10B ASN 1 15 NA NA nan nan nan nan nan nan 572 95.3333 6 5 1 1.8667 0.5524 3 0.4821 10.4385 1.6667 1.2222 1.0 4 0.2284 118.8281 0.5625 0.0184 0.5 0.8333 0.3333 2.1667 11.4722 0.0 9.0 window_2 67
    ALG10B EUR 1 15 NA NA nan nan nan nan nan nan 758 84.2222 9 7 2 1.8636 0.5043 3 0.219 41.1918 1.5556 1.5802 1.0 5 0.1249 167.8541 0.2405 0.0042 0.2667 0.32 0.1944 2.1111 20.0988 0.0 14.0 window_2 67
    ALG10B glob 1 15 NA NA nan nan nan nan nan nan 2184 128.4706 17 12 5 1.8889 0.5587 3 0.5169 8.2374 1.4118 1.301 1.0 5 0.1707 559.7036 0.0799 0.0002 0.0714 0.0988 0.0882 1.8824 23.1626 0.0 18.0 window_3 67
    ALG10B global_noAMR 1 15 NA NA nan nan nan nan nan nan 1700 113.3333 15 10 5 1.8462 0.6154 3 0.5103 8.48 1.3333 0.8889 1.0 4 0.1594 330.2159 0.0883 0.0003 0.0769 0.1094 0.0952 1.4667 12.9156 0.0 12.0 window_3 67
    ALG10B AFR 1 15 NA NA nan nan nan nan nan nan 370 33.6364 11 6 5 1.6667 0.6061 3 0.4782 6.3467 1.0909 0.6281 1.0 3 0.1386 49.2201 0.115 0.0004 0.1 0.1408 0.1091 0.7273 2.562 0.0 5.0 window_3 67
    ALG10B ASN 1 15 NA NA nan nan nan nan nan nan 572 114.4 5 2 3 1.3333 0.3333 2 0.951 1.9311 0.8 0.56 1.0 2 0.2853 58.6601 0.2697 0.0033 0.3077 0.3333 0.2 0.2 0.16 0.0 1.0 window_3 67
    ALG10B EUR 1 15 NA NA nan nan nan nan nan nan 758 94.75 8 5 3 1.2857 0.2381 2 0.3792 7.2485 1.25 0.1875 1.0 2 0.1926 213.9573 0.1588 0.0001 0.1628 0.1667 0.1786 0.25 0.1875 0.0 1.0 window_3 67
    CCR5 glob 1 15 NA NA nan nan nan nan nan nan 2184 75.3103 29 27 7 1.9878 0.7529 4 0.2522 22.8001 1.8621 1.3603 2.0 5 0.1287 999.0241 0.0434 0.0 0.0414 0.0521 0.0665 2.7931 25.7254 1.0 23.0 window_0 31
    CCR5 global_noAMR 1 15 NA NA nan nan nan nan nan nan 1700 73.913 23 22 5 1.9355 0.7171 4 0.2787 22.1694 1.913 1.0359 2.0 5 0.1407 820.4147 0.0578 0.0001 0.0524 0.0705 0.087 2.5217 23.7291 1.0 20.6333 window_0 31
    CCR5 AFR 1 15 NA NA nan nan nan nan nan nan 370 30.8333 12 9 4 1.6842 0.5614 3 0.3054 13.3438 1.5 0.75 1.0 3 0.1392 134.2034 0.1149 0.0005 0.1163 0.1392 0.1364 1.0833 3.2431 0.0 5.0 window_0 31
    CCR5 ASN 1 15 NA NA nan nan nan nan nan nan 572 44.0 13 11 3 1.7692 0.5846 3 0.5069 12.0127 1.6923 0.6746 1.0 3 0.2191 316.6415 0.1097 0.0002 0.1101 0.1224 0.141 1.5385 6.287 0.0 7.0 window_0 31
    CCR5 EUR 1 15 NA NA nan nan nan nan nan nan 758 54.1429 14 12 4 1.5833 0.4275 3 0.2593 8.8599 1.7143 0.7755 2.0 3 0.1857 477.7903 0.0949 0.0002 0.0903 0.1092 0.1319 1.0 1.5 0.8333 3.3333 window_0 31
    CCR5 glob 1 15 NA NA nan nan nan nan nan nan 2184 145.6 15 12 3 2.2414 0.7126 4 1.0585 13.9701 1.6 2.1067 1.0 6 0.2883 238.8321 0.1439 0.0018 0.1628 0.1892 0.1143 4.8 117.0933 0.0 38.0 window_1 31
    CCR5 global_noAMR 1 15 NA NA nan nan nan nan nan nan 1700 113.3333 15 12 3 2.2414 0.7126 4 1.0489 13.8368 1.6 2.1067 1.0 6 0.2857 216.6399 0.1439 0.0018 0.1628 0.1892 0.1143 4.8 117.0933 0.0 38.0 window_1 31
    CCR5 AFR 1 15 NA NA nan nan nan nan nan nan 370 46.25 8 5 3 1.5556 0.5278 3 0.567 14.7361 1.25 0.4375 1.0 2 0.1899 39.0907 0.1718 0.0005 0.1754 0.1944 0.1786 0.625 0.7344 0.0 2.0 window_1 31
    CCR5 ASN 1 15 NA NA nan nan nan nan nan nan 572 143.0 4 3 1 1.5 0.3 2 0.8654 2.9414 1.5 0.75 1.0 3 0.4327 12.666 0.7 0.03 0.6 1.0 0.5 0.75 1.6875 0.0 3.0 window_1 31
    CCR5 EUR 1 15 NA NA nan nan nan nan nan nan 758 84.2222 9 7 2 2.2143 0.8413 4 1.0809 6.5513 1.5556 1.358 1.0 4 0.3405 101.9361 0.3077 0.0067 0.32 0.4211 0.1944 3.7778 35.284 0.0 17.0 window_1 31
    <BLANKLINE>

"""


def test_window_lenght():
    """
    the CCR5 gene is 31 snps long. So, it should show up in the results if the window_size is 30 or 31, but not if it is 32.

    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --data_basedir=./test/test_data --windows_size 30"
    >>> output30 = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> print output30 #doctest: +NORMALIZE_WHITESPACE
    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    ALG10B 30 2184 glob 10 5 1.3939 window_0 67
    ALG10B 30 1700 global_noAMR 10 5 1.3548 window_0 67
    ALG10B 30 370 AFR 8 4 1.0588 window_0 67
    ALG10B 30 572 ASN 5 2 1.0 window_0 67
    ALG10B 30 758 EUR 6 3 1.3333 window_0 67
    ALG10B 30 2184 glob 9 6 1.5 window_1 67
    ALG10B 30 1700 global_noAMR 9 5 1.3571 window_1 67
    ALG10B 30 370 AFR 9 4 1.1429 window_1 67
    ALG10B 30 572 ASN 4 2 1.0 window_1 67
    ALG10B 30 758 EUR 4 4 1.5 window_1 67
    CCR5 30 2184 glob 8 8 2.0 window_0 31
    CCR5 30 1700 global_noAMR 6 8 2.0 window_0 31
    CCR5 30 370 AFR 5 4 1.5556 window_0 31
    CCR5 30 572 ASN 3 4 1.75 window_0 31
    CCR5 30 758 EUR 4 5 1.9048 window_0 31
    <BLANKLINE>

    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --data_basedir=./test/test_data --windows_size 31"
    >>> output31 = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> print output31 #doctest: +NORMALIZE_WHITESPACE
    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    ALG10B 31 2184 glob 10 5 1.4118 window_0 67
    ALG10B 31 1700 global_noAMR 10 5 1.3548 window_0 67
    ALG10B 31 370 AFR 8 4 1.0588 window_0 67
    ALG10B 31 572 ASN 5 2 1.0 window_0 67
    ALG10B 31 758 EUR 6 3 1.3333 window_0 67
    ALG10B 31 2184 glob 9 6 1.5294 window_1 67
    ALG10B 31 1700 global_noAMR 9 5 1.4 window_1 67
    ALG10B 31 370 AFR 9 4 1.1818 window_1 67
    ALG10B 31 572 ASN 4 2 1.0 window_1 67
    ALG10B 31 758 EUR 4 4 1.5294 window_1 67
    CCR5 31 2184 glob 9 7 1.92 window_0 31
    CCR5 31 1700 global_noAMR 7 7 1.907 window_0 31
    CCR5 31 370 AFR 5 4 1.6 window_0 31
    CCR5 31 572 ASN 4 5 1.6667 window_0 31
    CCR5 31 758 EUR 5 5 1.8095 window_0 31
    <BLANKLINE>

    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --data_basedir=./test/test_data --windows_size 32"
    >>> output32 = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> print output32 #doctest: +NORMALIZE_WHITESPACE
    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    ALG10B 32 2184 glob 11 5 1.3714 window_0 67
    ALG10B 32 1700 global_noAMR 11 5 1.3125 window_0 67
    ALG10B 32 370 AFR 9 4 0.9412 window_0 67
    ALG10B 32 572 ASN 5 2 1.0 window_0 67
    ALG10B 32 758 EUR 6 3 1.3684 window_0 67
    ALG10B 32 2184 glob 9 6 1.5676 window_1 67
    ALG10B 32 1700 global_noAMR 9 5 1.4194 window_1 67
    ALG10B 32 370 AFR 9 4 1.2174 window_1 67
    ALG10B 32 572 ASN 4 2 1.0 window_1 67
    ALG10B 32 758 EUR 4 4 1.5294 window_1 67
    <BLANKLINE>


    """
