#!/usr/bin/env python
import subprocess
def testDebugReport():
    """
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --data_basedir=./test/test_data"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> print output #doctest: +NORMALIZE_WHITESPACE 
    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    ALG3 16 2184 glob 3 5 2.0 window_0 16
    ALG3 16 1700 global_noAMR 5 5 1.8 window_0 16
    ALG3 16 370 AFR 4 4 1.7333 window_0 16
    ALG3 16 572 ASN 2 2 1.3333 window_0 16
    ALG3 16 758 EUR 3 3 1.3333 window_0 16
    ALG10B 67 2184 glob 22 10 1.4366 window_0 67
    ALG10B 67 1700 global_noAMR 22 8 1.3115 window_0 67
    ALG10B 67 370 AFR 18 4 0.7143 window_0 67
    ALG10B 67 572 ASN 9 3 1.0588 window_0 67
    ALG10B 67 758 EUR 10 7 1.3548 window_0 67
    CCR5 31 2184 glob 9 7 1.92 window_0 31
    CCR5 31 1700 global_noAMR 7 7 1.907 window_0 31
    CCR5 31 370 AFR 5 4 1.6 window_0 31
    CCR5 31 572 ASN 4 5 1.6667 window_0 31
    CCR5 31 758 EUR 5 5 1.8095 window_0 31
    <BLANKLINE>

  
    """
def testDebugHDF5Report():
    """
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --data_basedir=./test/test_data --hdf5"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> print output #doctest: +NORMALIZE_WHITESPACE 
    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    ALG3 16 2184 glob 3 5 2.0 window_0 16
    ALG3 16 1700 global_noAMR 5 5 1.8 window_0 16
    ALG3 16 370 AFR 4 4 1.7333 window_0 16
    ALG3 16 572 ASN 2 2 1.3333 window_0 16
    ALG3 16 758 EUR 3 3 1.3333 window_0 16
    ALG10B 67 2184 glob 22 10 1.4366 window_0 67
    ALG10B 67 1700 global_noAMR 22 8 1.3115 window_0 67
    ALG10B 67 370 AFR 18 4 0.7143 window_0 67
    ALG10B 67 572 ASN 9 3 1.0588 window_0 67
    ALG10B 67 758 EUR 10 7 1.3548 window_0 67
    CCR5 31 2184 glob 9 7 1.92 window_0 31
    CCR5 31 1700 global_noAMR 7 7 1.907 window_0 31
    CCR5 31 370 AFR 5 4 1.6 window_0 31
    CCR5 31 572 ASN 4 5 1.6667 window_0 31
    CCR5 31 758 EUR 5 5 1.8095 window_0 31
    <BLANKLINE>

    """
def testDebugReportMedianVar():
    """
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug_median.yaml --no-debug --data_basedir=./test/test_data"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> print output #doctest: +NORMALIZE_WHITESPACE 
    gene pop max_degree av_degree median_degree median_closeness max_closeness median_betweenness max_betweenness window whole_gene_nsnps
    ALG3 glob 5 2.0 2.0 0.1024 0.1141 5.0667 45.0333 window_0 16
    ALG3 global_noAMR 5 1.8 1.0 0.1067 0.1166 0.0 30.8333 window_0 16
    ALG3 AFR 4 1.7333 1.0 0.1239 0.1359 0.0 11.6667 window_0 16
    ALG3 ASN 2 1.3333 1.0 0.2381 0.25 0.0 1.0 window_0 16
    ALG3 EUR 3 1.3333 1.0 0.16 0.1667 0.0 3.0 window_0 16
    ALG10B glob 10 1.4366 1.0 0.0156 0.0164 0.0 45.0 window_0 67
    ALG10B global_noAMR 8 1.3115 1.0 0.0178 0.0189 0.0 28.0 window_0 67
    ALG10B AFR 4 0.7143 1.0 0.037 0.0434 0.0 9.0 window_0 67
    ALG10B ASN 3 1.0588 1.0 0.0708 0.0766 0.0 3.5 window_0 67
    ALG10B EUR 7 1.3548 1.0 0.0409 0.0417 0.0 21.0 window_0 67
    CCR5 glob 7 1.92 1.0 0.0267 0.0293 0.0 75.3333 window_0 31
    CCR5 global_noAMR 7 1.907 1.0 0.0309 0.0355 0.0 71.3 window_0 31
    CCR5 AFR 4 1.6 1.0 0.0586 0.076 0.0 15.0 window_0 31
    CCR5 ASN 5 1.6667 1.0 0.0819 0.0899 0.0 18.0 window_0 31
    CCR5 EUR 5 1.8095 2.0 0.0658 0.0707 0.5 12.5 window_0 31
    <BLANKLINE>

      
    """


def testDebugReportDistance2():
    """
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --distance 2 --data_basedir=./test/test_data"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> print output #doctest: +NORMALIZE_WHITESPACE
    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    ALG3 16 2184 glob 2 9 5.2727 window_0 16
    ALG3 16 1700 global_noAMR 2 9 5.0 window_0 16
    ALG3 16 370 AFR 1 8 4.2667 window_0 16
    ALG3 16 572 ASN 1 3 2.6667 window_0 16
    ALG3 16 758 EUR 2 5 3.1111 window_0 16
    ALG10B 67 2184 glob 15 10 4.6479 window_0 67
    ALG10B 67 1700 global_noAMR 15 8 3.6721 window_0 67
    ALG10B 67 370 AFR 14 5 1.5714 window_0 67
    ALG10B 67 572 ASN 7 4 2.1176 window_0 67
    ALG10B 67 758 EUR 8 7 3.7419 window_0 67
    CCR5 31 2184 glob 6 17 5.88 window_0 31
    CCR5 31 1700 global_noAMR 5 16 5.7674 window_0 31
    CCR5 31 370 AFR 4 7 3.2 window_0 31
    CCR5 31 572 ASN 3 8 4.2222 window_0 31
    CCR5 31 758 EUR 4 7 4.2857 window_0 31
    <BLANKLINE>

    """

def testDebugReportReadGraphml():
    """
    Test whether the ReportFile can correctly read graphml files.

    Note: I need to save the graphml files before running this test, be careful when debugging.

    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --write_graphml --data_basedir=./test/test_data"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --read_graphml_if_possible --data_basedir=./test/test_data"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> print output #doctest: +NORMALIZE_WHITESPACE
    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    ALG3 16 2184 glob 3 5 2.0 window_0 16
    ALG3 16 1700 global_noAMR 5 5 1.8 window_0 16
    ALG3 16 370 AFR 4 4 1.7333 window_0 16
    ALG3 16 572 ASN 2 2 1.3333 window_0 16
    ALG3 16 758 EUR 3 3 1.3333 window_0 16
    ALG10B 67 2184 glob 22 10 1.4366 window_0 67
    ALG10B 67 1700 global_noAMR 22 8 1.3115 window_0 67
    ALG10B 67 370 AFR 18 4 0.7143 window_0 67
    ALG10B 67 572 ASN 9 3 1.0588 window_0 67
    ALG10B 67 758 EUR 10 7 1.3548 window_0 67
    CCR5 31 2184 glob 9 7 1.92 window_0 31
    CCR5 31 1700 global_noAMR 7 7 1.907 window_0 31
    CCR5 31 370 AFR 5 4 1.6 window_0 31
    CCR5 31 572 ASN 4 5 1.6667 window_0 31
    CCR5 31 758 EUR 5 5 1.8095 window_0 31
    <BLANKLINE>

     
    """

def testDebugReportSavePickle():
    """
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --write_pickle --overwrite_existing --data_basedir=./test/test_data"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> print output #doctest: +NORMALIZE_WHITESPACE
    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    ALG3 16 2184 glob 3 5 2.0 window_0 16
    ALG3 16 1700 global_noAMR 5 5 1.8 window_0 16
    ALG3 16 370 AFR 4 4 1.7333 window_0 16
    ALG3 16 572 ASN 2 2 1.3333 window_0 16
    ALG3 16 758 EUR 3 3 1.3333 window_0 16
    ALG10B 67 2184 glob 22 10 1.4366 window_0 67
    ALG10B 67 1700 global_noAMR 22 8 1.3115 window_0 67
    ALG10B 67 370 AFR 18 4 0.7143 window_0 67
    ALG10B 67 572 ASN 9 3 1.0588 window_0 67
    ALG10B 67 758 EUR 10 7 1.3548 window_0 67
    CCR5 31 2184 glob 9 7 1.92 window_0 31
    CCR5 31 1700 global_noAMR 7 7 1.907 window_0 31
    CCR5 31 370 AFR 5 4 1.6 window_0 31
    CCR5 31 572 ASN 4 5 1.6667 window_0 31
    CCR5 31 758 EUR 5 5 1.8095 window_0 31
    <BLANKLINE>

      
    >>> print subprocess.check_output(['ls', 'test/test_data/pickles/ALG3_glob_distance1.pickle'])
    test/test_data/pickles/ALG3_glob_distance1.pickle
    <BLANKLINE>

    """

def testDebugReportSaveGraphML():
    """
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p test/test_data/params/debug.yaml --no-debug --write_graphml --overwrite_existing --data_basedir=./test/test_data"
    >>> import logging
    >>> logging.debug(command)
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> print output #doctest: +NORMALIZE_WHITESPACE
    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    ALG3 16 2184 glob 3 5 2.0 window_0 16
    ALG3 16 1700 global_noAMR 5 5 1.8 window_0 16
    ALG3 16 370 AFR 4 4 1.7333 window_0 16
    ALG3 16 572 ASN 2 2 1.3333 window_0 16
    ALG3 16 758 EUR 3 3 1.3333 window_0 16
    ALG10B 67 2184 glob 22 10 1.4366 window_0 67
    ALG10B 67 1700 global_noAMR 22 8 1.3115 window_0 67
    ALG10B 67 370 AFR 18 4 0.7143 window_0 67
    ALG10B 67 572 ASN 9 3 1.0588 window_0 67
    ALG10B 67 758 EUR 10 7 1.3548 window_0 67
    CCR5 31 2184 glob 9 7 1.92 window_0 31
    CCR5 31 1700 global_noAMR 7 7 1.907 window_0 31
    CCR5 31 370 AFR 5 4 1.6 window_0 31
    CCR5 31 572 ASN 4 5 1.6667 window_0 31
    CCR5 31 758 EUR 5 5 1.8095 window_0 31
    <BLANKLINE>

      
    >>> print subprocess.check_output(['ls', 'test/test_data/graphml/ALG3_glob_distance1.graphmlz'])
    test/test_data/graphml/ALG3_glob_distance1.graphmlz
    <BLANKLINE>

    """

def testFullReport():
    """
    >>> command = "python src/generate_network_report.py  -f test/test_data/params/pathways/debug_pathway.genes -p params/default.yaml --no-debug --data_basedir=./test/test_data"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> print output #doctest: +NORMALIZE_WHITESPACE
    gene continent distance_definition n_snps central_snp chromosome central_snp_position upstream_position downstream_position region_size distance_from_upstream_margin distance_from_downstream_margin n_datapoints av_datapoints_per_node n_vertices n_edges n_components av_path_length var_path_length diameter av_w_path_length av_w_path_length_inv av_degree var_degree median_degree max_degree av_w_degree av_w_degree_inv av_closeness var_closeness median_closeness max_closeness density av_betweenness var_betweenness median_betweenness max_betweenness window whole_gene_nsnps
    ALG3 glob 1 16 NA NA nan nan nan nan nan nan 2184 99.2727 22 22 3 3.0167 2.5207 7 0.5917 217.6912 2.0 1.4545 2.0 5 0.1957 1009.8819 0.0903 0.0006 0.1024 0.1141 0.0952 11.0 189.4226 5.0667 45.0333 window_0 16
    ALG3 global_noAMR 1 16 NA NA nan nan nan nan nan nan 1700 85.0 20 18 5 2.5976 1.6262 5 0.686 98.7069 1.8 1.76 1.0 5 0.2115 522.6159 0.0905 0.0008 0.1067 0.1166 0.0947 6.55 101.0368 0.0 30.8333 window_0 16
    ALG3 AFR 1 16 NA NA nan nan nan nan nan nan 370 24.6667 15 13 4 2.125 1.0353 4 0.2759 29.5148 1.7333 1.1289 1.0 4 0.111 189.3458 0.1073 0.0008 0.1239 0.1359 0.1238 3.0 17.5667 0.0 11.6667 window_0 16
    ALG3 ASN 1 16 NA NA nan nan nan nan nan nan 572 95.3333 6 4 2 1.3333 0.2667 2 0.5676 7.8253 1.3333 0.2222 1.0 2 0.2838 121.1376 0.2421 0.0 0.2381 0.25 0.2667 0.3333 0.2222 0.0 1.0 window_0 16
    ALG3 EUR 1 16 NA NA nan nan nan nan nan nan 758 84.2222 9 6 3 1.5833 0.447 3 0.6569 11.6248 1.3333 0.6667 1.0 3 0.2838 197.9591 0.1553 0.0003 0.16 0.1667 0.1667 0.7778 1.284 0.0 3.0 window_0 16
    ALG10B glob 1 67 NA NA nan nan nan nan nan nan 2184 30.7606 71 51 22 2.0386 0.6101 4 0.2408 99.9961 1.4366 2.4432 1.0 10 0.0698 772.012 0.0154 0.0 0.0156 0.0164 0.0205 3.0282 63.0696 0.0 45.0 window_0 67
    ALG10B global_noAMR 1 67 NA NA nan nan nan nan nan nan 1700 27.8689 61 40 22 1.9542 0.6594 4 0.2419 95.2557 1.3115 1.7227 1.0 8 0.067 570.323 0.0177 0.0 0.0178 0.0189 0.0219 2.0492 25.2107 0.0 28.0 window_0 67
    ALG10B AFR 1 67 NA NA nan nan nan nan nan nan 370 13.2143 28 10 18 1.6667 0.5333 3 0.1846 17.1719 0.7143 0.7755 1.0 4 0.0396 39.6161 0.0379 0.0 0.037 0.0434 0.0265 0.5 3.25 0.0 9.0 window_0 67
    ALG10B ASN 1 67 NA NA nan nan nan nan nan nan 572 33.6471 17 9 9 1.5294 0.3897 3 0.3632 11.3932 1.0588 0.9965 1.0 3 0.1238 216.106 0.0672 0.0001 0.0708 0.0766 0.0662 0.5294 1.1021 0.0 3.5 window_0 67
    ALG10B EUR 1 67 NA NA nan nan nan nan nan nan 758 24.4516 31 21 10 1.9104 0.6282 4 0.5247 48.6051 1.3548 1.7128 1.0 7 0.1499 300.2533 0.0377 0.0 0.0409 0.0417 0.0452 1.9677 25.3861 0.0 21.0 window_0 67
    CCR5 glob 1 31 NA NA nan nan nan nan nan nan 2184 43.68 50 48 9 2.4134 0.9549 5 0.296 182.6541 1.92 2.4336 1.0 7 0.1032 1036.5362 0.0254 0.0 0.0267 0.0293 0.0392 7.18 247.4076 0.0 75.3333 window_0 31
    CCR5 global_noAMR 1 31 NA NA nan nan nan nan nan nan 1700 39.5349 43 41 7 2.3561 0.9069 5 0.3412 143.8398 1.907 2.2704 1.0 7 0.1171 861.2989 0.0303 0.0 0.0309 0.0355 0.0454 6.4651 218.5459 0.0 71.3 window_0 31
    CCR5 AFR 1 31 NA NA nan nan nan nan nan nan 370 18.5 20 16 5 1.9524 0.8269 4 0.2458 25.882 1.6 0.64 1.0 4 0.0991 146.8105 0.0637 0.0001 0.0586 0.076 0.0842 2.0 13.3 0.0 15.0 window_0 31
    CCR5 ASN 1 31 NA NA nan nan nan nan nan nan 572 31.7778 18 15 4 2.0 0.6531 4 0.5266 46.2719 1.6667 1.4444 1.0 5 0.1909 336.7237 0.08 0.0001 0.0819 0.0899 0.098 2.7778 26.2006 0.0 18.0 window_0 31
    CCR5 EUR 1 31 NA NA nan nan nan nan nan nan 758 36.0952 21 19 5 1.8727 0.5946 4 0.3266 14.0487 1.8095 1.4875 2.0 5 0.1626 439.5752 0.0635 0.0001 0.0658 0.0707 0.0905 2.2857 13.384 0.5 12.5 window_0 31
    <BLANKLINE>

"""
