#!/usr/bin/env python
import subprocess
def testDebugReport():
    """
    >>> command = "python src/vcf2networks.py  --config test/test_data/params/debug.yaml --no-debug --vcf=test/test_data/vcf/ALG11.vcf.gz --individuals=test/test_data/individuals_annotations.txt"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> print output #doctest: +NORMALIZE_WHITESPACE 
    gene continent n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    gene glob 498 2184 glob 139 58 1.4834 window_0 498
    gene EUR 498 758 glob 37 19 1.5974 window_0 498
    gene ASN 498 572 glob 35 32 1.5323 window_0 498
    gene AMR 498 362 glob 38 15 1.3621 window_0 498
    gene AFR 498 492 glob 74 17 1.1026 window_0 498
    <BLANKLINE>
  
    """

def testDebugReportSubSample():
    """
    >>> command = "python src/vcf2networks.py --sample 200 --random_seed 2 --config test/test_data/params/debug.yaml --no-debug --vcf=test/test_data/vcf/ALG11.vcf.gz --individuals=test/test_data/individuals_annotations.txt"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> print output #doctest: +NORMALIZE_WHITESPACE 
    gene continent n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    gene glob 498 2184 glob 139 58 1.4834 window_0 498
    gene global_sub 498 200 glob 38 14 1.2553 window_0 498
    gene EUR 498 200 glob 22 12 1.4667 window_0 498
    gene ASN 498 200 glob 25 18 1.2698 window_0 498
    gene AMR 498 200 glob 33 12 1.1646 window_0 498
    gene AFR 498 200 glob 46 11 1.102 window_0 498
    <BLANKLINE>
     """
def testDebugReportWindowsNoOverlapping():
    """
    >>> command = "python src/vcf2networks.py --windows_size 200 --random_seed 2 --config test/test_data/params/debug.yaml --no-debug --vcf=test/test_data/vcf/ALG11.vcf.gz --individuals=test/test_data/individuals_annotations.txt"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> print output #doctest: +NORMALIZE_WHITESPACE 
    gene continent n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    gene glob 200 2184 glob 43 46 1.6146 window_0 498
    gene EUR 200 758 glob 11 23 1.6842 window_0 498
    gene ASN 200 572 glob 7 19 1.8214 window_0 498
    gene AMR 200 362 glob 16 12 1.3725 window_0 498
    gene AFR 200 492 glob 30 19 1.2208 window_0 498
    gene glob 200 2184 glob 29 48 1.7191 window_1 498
    gene EUR 200 758 glob 7 25 1.8246 window_1 498
    gene ASN 200 572 glob 11 13 1.5217 window_1 498
    gene AMR 200 362 glob 13 14 1.5 window_1 498
    gene AFR 200 492 glob 24 27 1.4321 window_1 498
     """


def testDebugReportWindowsNoOverlappingAndSample():
    """
    >>> command = "python src/vcf2networks.py --sample 200 -w 200 --random_seed 2 --config test/test_data/params/debug.yaml --no-debug --vcf=test/test_data/vcf/ALG11.vcf.gz --individuals=test/test_data/individuals_annotations.txt"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> print output #doctest: +NORMALIZE_WHITESPACE 
    gene continent n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    gene glob 200 2184 glob 43 46 1.6146 window_0 498
    gene global_sub 200 200 glob 16 10 1.2381 window_0 498
    gene EUR 200 200 glob 8 9 1.4286 window_0 498
    gene ASN 200 200 glob 8 12 1.5294 window_0 498
    gene AMR 200 200 glob 14 9 1.2821 window_0 498
    gene AFR 200 200 glob 19 13 1.1915 window_0 498
    gene glob 200 2184 glob 29 48 1.7191 window_1 498
    gene global_sub 200 200 glob 13 13 1.4583 window_1 498
    gene EUR 200 200 glob 6 15 1.6667 window_1 498
    gene ASN 200 200 glob 9 7 1.3333 window_1 498
    gene AMR 200 200 glob 11 9 1.3125 window_1 498
    gene AFR 200 200 glob 26 20 1.1071 window_1 498
     """



def testDebugReportPhenotype1():
    """
    >>> command = "python src/vcf2networks.py --phenotype PHENOTYPE1  --config test/test_data/params/debug.yaml --no-debug --vcf=test/test_data/vcf/ALG11.vcf.gz --individuals=test/test_data/individuals_annotations.txt"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> print output #doctest: +NORMALIZE_WHITESPACE 
    gene PHENOTYPE1 n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    gene glob 498 2184 glob 139 58 1.4834 window_0 498
    gene pink 498 1508 glob 114 46 1.4065 window_0 498
    gene blue 498 676 glob 81 32 1.4103 window_0 498
    <BLANKLINE>

    """

def testDebugReportPhenotype1LowerCase():
    """
    >>> command = "python src/vcf2networks.py --phenotype phenotype1  --config test/test_data/params/debug.yaml --no-debug --vcf=test/test_data/vcf/ALG11.vcf.gz --individuals=test/test_data/individuals_annotations.txt"
     >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> print output #doctest: +NORMALIZE_WHITESPACE 
    gene phenotype1 n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    gene glob 498 2184 glob 139 58 1.4834 window_0 498
    gene pink 498 1508 glob 114 46 1.4065 window_0 498
    gene blue 498 676 glob 81 32 1.4103 window_0 498
    <BLANKLINE> 
 
    """

#def testDebugHDF5Report():
#    """
#    >>> command = "python src/vcf2networks.py  --config test/test_data/params/debug.yaml --no-debug --vcf=test/test_data/vcf/ALG11.vcf.gz --individuals=test/test_data/individuals_annotations.txt"
#    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
#
#    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
#    >>> print output #doctest: +NORMALIZE_WHITESPACE 
#    gene continent n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
#    gene glob 498 2184 glob 139 58 1.4834 window_0 498
#    gene EUR 498 758 glob 37 19 1.5974 window_0 498
#    gene ASN 498 572 glob 35 32 1.5323 window_0 498
#    gene AMR 498 362 glob 38 15 1.3621 window_0 498
#    gene AFR 498 492 glob 74 17 1.1026 window_0 498
#    <BLANKLINE>
#
#    """

def testDebugReportMedianVar():
    """
    >>> command = "python src/vcf2networks.py  --config test/test_data/params/debug_median.yaml --no-debug --vcf=test/test_data/vcf/ALG11.vcf.gz --individuals=test/test_data/individuals_annotations.txt"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)

    #NOTE: the blankline at the end is generated by subprocess.check_output, not by the script
    >>> print output #doctest: +NORMALIZE_WHITESPACE 
    gene continent pop max_degree av_degree median_degree median_closeness max_closeness median_betweenness max_betweenness window whole_gene_nsnps
    gene glob glob 58 1.4834 1.0 0.0023 0.003 0.0 4971.8333 window_0 498
    gene EUR glob 19 1.5974 1.0 0.0073 0.0114 0.0 1620.8667 window_0 498
    gene ASN glob 32 1.5323 1.0 0.0111 0.0123 0.0 879.0 window_0 498
    gene AMR glob 15 1.3621 1.0 0.0093 0.0122 0.0 464.5 window_0 498
    gene AFR glob 17 1.1026 1.0 0.0065 0.0092 0.0 891.0 window_0 498
    <BLANKLINE>
      
    """


def testDebugReportDistance2():
    """
    >>> command = "python src/vcf2networks.py  --config test/test_data/params/debug.yaml --no-debug --distance 2 --vcf=test/test_data/vcf/ALG11.vcf.gz --individuals=test/test_data/individuals_annotations.txt"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> print output #doctest: +NORMALIZE_WHITESPACE
    gene continent n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
    gene glob 498 2184 glob 67 102 16.4459 window_0 498
    gene EUR 498 758 glob 18 56 9.4416 window_0 498
    gene ASN 498 572 glob 11 43 13.6613 window_0 498
    gene AMR 498 362 glob 18 32 6.5862 window_0 498
    gene AFR 498 492 glob 48 42 4.9744 window_0 498
    <BLANKLINE>
    """

#def testDebugReportReadGraphml(): # Test inactivated because graphml functionality is no longer supported
#    """
#    Test whether the ReportFile can correctly read graphml files.
#
#    Note: I need to save the graphml files before running this test, be careful when debugging.
#
#    >>> command = "python src/vcf2networks.py --config test/test_data/params/debug.yaml --no-debug --write_graphml --vcf=test/test_data/vcf/ALG11.vcf.gz --individuals=test/test_data/individuals_annotations.txt"
#    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
#    >>> command = "python src/vcf2networks.py   --config test/test_data/params/debug.yaml --no-debug --read_graphml_if_possible --vcf=test/test_data/vcf/ALG11.vcf.gz --individuals=test/test_data/individuals_annotations.txt"
#    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
#    >>> print output #doctest: +NORMALIZE_WHITESPACE
#    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
#    ALG3 16 2184 glob 3 5 2.0 window_0 16
#    ALG3 16 1700 global_noAMR 5 5 1.8 window_0 16
#    ALG3 16 370 AFR 4 4 1.7333 window_0 16
#    ALG3 16 572 ASN 2 2 1.3333 window_0 16
#    ALG3 16 758 EUR 3 3 1.3333 window_0 16
#    ALG10B 67 2184 glob 22 10 1.4366 window_0 67
#    ALG10B 67 1700 global_noAMR 22 8 1.3115 window_0 67
#    ALG10B 67 370 AFR 18 4 0.7143 window_0 67
#    ALG10B 67 572 ASN 9 3 1.0588 window_0 67
#    ALG10B 67 758 EUR 10 7 1.3548 window_0 67
#    CCR5 31 2184 glob 9 7 1.92 window_0 31
#    CCR5 31 1700 global_noAMR 7 7 1.907 window_0 31
#    CCR5 31 370 AFR 5 4 1.6 window_0 31
#    CCR5 31 572 ASN 4 5 1.6667 window_0 31
#    CCR5 31 758 EUR 5 5 1.8095 window_0 31
#    <BLANKLINE>
#
#     
#    """

#def testDebugReportSavePickle():
#    """
#    >>> command = "python src/vcf2networks.py  --config test/test_data/params/debug.yaml --no-debug --write_pickle --overwrite_existing --vcf=test/test_data/vcf/ALG11.vcf.gz --individuals=test/test_data/individuals_annotations.txt"
#    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
#    >>> print output #doctest: +NORMALIZE_WHITESPACE
#    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
#    ALG3 16 2184 glob 3 5 2.0 window_0 16
#    ALG3 16 1700 global_noAMR 5 5 1.8 window_0 16
#    ALG3 16 370 AFR 4 4 1.7333 window_0 16
#    ALG3 16 572 ASN 2 2 1.3333 window_0 16
#    ALG3 16 758 EUR 3 3 1.3333 window_0 16
#    ALG10B 67 2184 glob 22 10 1.4366 window_0 67
#    ALG10B 67 1700 global_noAMR 22 8 1.3115 window_0 67
#    ALG10B 67 370 AFR 18 4 0.7143 window_0 67
#    ALG10B 67 572 ASN 9 3 1.0588 window_0 67
#    ALG10B 67 758 EUR 10 7 1.3548 window_0 67
#    CCR5 31 2184 glob 9 7 1.92 window_0 31
#    CCR5 31 1700 global_noAMR 7 7 1.907 window_0 31
#    CCR5 31 370 AFR 5 4 1.6 window_0 31
#    CCR5 31 572 ASN 4 5 1.6667 window_0 31
#    CCR5 31 758 EUR 5 5 1.8095 window_0 31
#    <BLANKLINE>
#
#      
#    >>> print subprocess.check_output(['ls', 'test/test_data/pickles/ALG3_glob_distance1.pickle'])
#    test/test_data/pickles/ALG3_glob_distance1.pickle
#    <BLANKLINE>
#
#    """
#
#def testDebugReportSaveGraphML():
#    """
#    >>> command = "python src/vcf2networks.py  --config test/test_data/params/debug.yaml --no-debug --write_graphml --overwrite_existing --vcf=test/test_data/vcf/ALG11.vcf.gz --individuals=test/test_data/individuals_annotations.txt"
#    >>> import logging
#    >>> logging.debug(command)
#    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
#    >>> print output #doctest: +NORMALIZE_WHITESPACE
#    gene n_snps n_datapoints pop n_components max_degree av_degree window whole_gene_nsnps
#    ALG3 16 2184 glob 3 5 2.0 window_0 16
#    ALG3 16 1700 global_noAMR 5 5 1.8 window_0 16
#    ALG3 16 370 AFR 4 4 1.7333 window_0 16
#    ALG3 16 572 ASN 2 2 1.3333 window_0 16
#    ALG3 16 758 EUR 3 3 1.3333 window_0 16
#    ALG10B 67 2184 glob 22 10 1.4366 window_0 67
#    ALG10B 67 1700 global_noAMR 22 8 1.3115 window_0 67
#    ALG10B 67 370 AFR 18 4 0.7143 window_0 67
#    ALG10B 67 572 ASN 9 3 1.0588 window_0 67
#    ALG10B 67 758 EUR 10 7 1.3548 window_0 67
#    CCR5 31 2184 glob 9 7 1.92 window_0 31
#    CCR5 31 1700 global_noAMR 7 7 1.907 window_0 31
#    CCR5 31 370 AFR 5 4 1.6 window_0 31
#    CCR5 31 572 ASN 4 5 1.6667 window_0 31
#    CCR5 31 758 EUR 5 5 1.8095 window_0 31
#    <BLANKLINE>
#
#      
#    >>> print subprocess.check_output(['ls', 'test/test_data/graphml/ALG3_glob_distance1.graphmlz'])
#    test/test_data/graphml/ALG3_glob_distance1.graphmlz
#    <BLANKLINE>
#
#    """

def testFullReport():
    """
    >>> command = "python src/vcf2networks.py  --config params/default.yaml --no-debug --vcf=test/test_data/vcf/ALG11.vcf.gz --individuals=test/test_data/individuals_annotations.txt"
    >>> output = subprocess.check_output(command.split(), stderr=subprocess.PIPE)
    >>> print output #doctest: +NORMALIZE_WHITESPACE
    file_prefix continent n_snps central_snp chromosome central_snp_position region_size n_datapoints av_datapoints_per_node n_vertices n_edges n_components av_path_length diameter av_w_path_length av_degree max_degree av_w_degree av_closeness max_closeness max_betweenness window whole_gene_nsnps
    ALG11 glob 498 rs180732214 13 52596009 41061 2184 4.8212 453 336 139 3.1726 7 0.223 1.4834 58 0.036 0.0026 0.003 4971.8333 window_0 498
    ALG11 EUR 498 rs180732214 13 52596009 41061 758 4.9221 154 123 37 3.2494 7 0.2695 1.5974 19 0.0478 0.0088 0.0114 1620.8667 window_0 498
    ALG11 ASN 498 rs180732214 13 52596009 41061 572 4.6129 124 95 35 2.6403 6 0.4627 1.5323 32 0.11 0.0104 0.0123 879.0 window_0 498
    ALG11 AMR 498 rs180732214 13 52596009 41061 362 3.1207 116 79 38 2.6722 5 0.2304 1.3621 15 0.0417 0.01 0.0122 464.5 window_0 498
    ALG11 AFR 498 rs180732214 13 52596009 41061 492 3.1538 156 86 74 3.0652 6 0.1698 1.1026 17 0.0176 0.0073 0.0092 891.0 window_0 498
    <BLANKLINE>
"""
