from vellum.ext.setup import *
from vellum.ext.setup import _gen_setup, _kwcall as kwcall

def test_kwcall():
    data = kwcall({'test':'test'})
    print data
    assert data == "\n    test='test'\n"


full_data = """#!/usr/bin/python
# THIS FILE IS AUTOGENERATED BY VELLUM
try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

setup(

)
"""


def test_full():
    set=dict(
        version="0.1",
        author='test',
        packages=[
          'foo'
        ],
        install_requires=[
        ],
    )
    data = _gen_setup(set)
    print data
    assert data == """#!/usr/bin/python
# THIS FILE IS AUTOGENERATED BY VELLUM
# if you need changes, do them in build.vel

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

setup(
    author='test',
    install_requires=[],
    packages=[
        'foo'
    ],
    version='0.1'
)
"""

