#!/usr/bin/env python3

import sys
import os

sys.path.insert(0, os.path.abspath('../..'))

extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.ifconfig',
]

templates_path = ['_templates']

source_suffix = '.rst'

master_doc = 'index'

project = 'vesna'

copyright = '2015, Evgeny Pisemsky'

version = '0.1.0'

release = '0.1.0'

exclude_patterns = []

pygments_style = 'sphinx'

html_theme = 'default'

html_static_path = ['_static']

htmlhelp_basename = 'vesnadoc'

latex_elements = {}

latex_documents = [
    ('index', 'vesna.tex', 'vesna documentation',
     'Evgeny Pisemsky', 'manual'),
]

man_pages = [
    ('index', 'vesna', 'vesna documentation',
     ['Evgeny Pisemsky'], 1)
]

texinfo_documents = [
    ('index', 'vesna', 'vesna documentation',
     'Evgeny Pisemsky', 'vesna',
     'Python client library to the http://vesna.yandex.ru/ fish text generator.',
     'Miscellaneous'),
]

intersphinx_mapping = {'http://docs.python.org/': None}
