getJasmineRequireObj().base = (function (jasmineGlobal) {
  if (typeof module !== 'undefined' && module.exports) {
    jasmineGlobal = global;
  }

  return function(j$) {
    j$.unimplementedMethod_ = function() {
      throw new Error('unimplemented method');
    };

    j$.MAX_PRETTY_PRINT_DEPTH = 40;
    j$.MAX_PRETTY_PRINT_ARRAY_LENGTH = 100;
    j$.DEFAULT_TIMEOUT_INTERVAL = 5000;

    j$.getGlobal = function() {
      return jasmineGlobal;
    };

    j$.getEnv = function(options) {
      var env = j$.currentEnv_ = j$.currentEnv_ || new j$.Env(options);
      //jasmine. singletons in here (setTimeout blah blah).
      return env;
    };

    j$.isArray_ = function(value) {
      return j$.isA_('Array', value);
    };

    j$.isString_ = function(value) {
      return j$.isA_('String', value);
    };

    j$.isNumber_ = function(value) {
      return j$.isA_('Number', value);
    };

    j$.isA_ = function(typeName, value) {
      return Object.prototype.toString.apply(value) === '[object ' + typeName + ']';
    };

    j$.isDomNode = function(obj) {
      return obj.nodeType > 0;
    };

    j$.any = function(clazz) {
      return new j$.Any(clazz);
    };

    j$.objectContaining = function(sample) {
      return new j$.ObjectContaining(sample);
    };

    j$.createSpy = function(name, originalFn) {

      var spyStrategy = new j$.SpyStrategy({
          name: name,
          fn: originalFn,
          getSpy: function() { return spy; }
        }),
        callTracker = new j$.CallTracker(),
        spy = function() {
          callTracker.track({
            object: this,
            args: Array.prototype.slice.apply(arguments)
          });
          return spyStrategy.exec.apply(this, arguments);
        };

      for (var prop in originalFn) {
        if (prop === 'and' || prop === 'calls') {
          throw new Error('Jasmine spies would overwrite the \'and\' and \'calls\' properties on the object being spied upon');
        }

        spy[prop] = originalFn[prop];
      }

      spy.and = spyStrategy;
      spy.calls = callTracker;

      return spy;
    };

    j$.isSpy = function(putativeSpy) {
      if (!putativeSpy) {
        return false;
      }
      return putativeSpy.and instanceof j$.SpyStrategy &&
        putativeSpy.calls instanceof j$.CallTracker;
    };

    j$.createSpyObj = function(baseName, methodNames) {
      if (!j$.isArray_(methodNames) || methodNames.length === 0) {
        throw 'createSpyObj requires a non-empty array of method names to create spies for';
      }
      var obj = {};
      for (var i = 0; i < methodNames.length; i++) {
        obj[methodNames[i]] = j$.createSpy(baseName + '.' + methodNames[i]);
      }
      return obj;
    };
  };
})(this);
