from viset.caltech import Caltech256
from viset.dataset import Viset
import cv

if __name__ == '__main__':
  # Create a new viset
  print 'Creating vision dataset for Caltech101 dataset'
  dbfile = Caltech256().export()
  print 'Exporting Caltech256 dataset to redistributable HDF5 file "' + dbfile + '"'
  
  # Import an existing viset 
  print 'Displaying all images in viset (VISion dataSET) "' + dbfile + '"'
  db = Viset(dbfile)
  for (im,annotation) in db.read(n_skip=100):
    print 'Image=' + str(annotation['id_img']) + ' Category=' + annotation['category']
    cv.ShowImage('Caltech256', cv.fromarray(im))
    cv.WaitKey(100)

  # Cleanup cached data (optional)
  print 'Deleting all cached data in "' + db.cachedir + '"'  
  db.delete()

  
