from viset.caltech import Caltech101
from viset.dataset import Viset
from viset.show import imshow
from time import sleep
import os.path

def test_create():
    print '[test_viset.test_create]: creating new viset for caltech101'    
    return Caltech101().export()
    
def test_open(dbfile):
    print '[test_viset.test_open]: open database'  
    db = Viset(dbfile)

    print '[test_viset.test_open]: open database from cache'
    db = Viset(os.path.basename(dbfile))
    
    print '[test_viset.test_open]: trying to open invalid database'  
    try:
        try:
            db = Viset('invalid.path.to.h5')  
            raise IOError('no error opening invalid dataset')
        except:
            print 'Correctly raised exception'        
        try:
            db = Viset(1)  
            raise IOError('no error opening invalid dataset')            
        except:
            print 'Correctly raised exceptions'        
        try:
            db = Viset('http://www.visym.com')
            raise IOError('no error opening invalid dataset')                        
        except:
            print 'Correctly raised exceptions'        
    except:
        raise
                
        
def test_query(dbfile):
    print '[test_viset.test_query]: query database'
    db = Viset(dbfile)
    print db.query(table='/images', row=0, field='url')
    print db.dbobj.root.images[0]['url']  # natural naming

    
def test_summary(dbfile):
    print '[test_viset.test_summary]: displaying summary of database'    
    print Viset(dbfile)

    
def test_split(dbfile):
    print '[test_viset.test_split]: dataset splits'  
    db = Viset(dbfile, strategy='kfold', kfold=3, datastep=1000)
    for k in range(0,2):
        for (im,anno) in db[k]['test']:
            print anno
    for (im,anno) in Viset(dbfile, datastep=1000)[0]:
        print anno
    db = Viset(dbfile, strategy='train_test_shuffle', datastep=1000)
    for (im,anno) in db['train']:
        print anno
    for (im,anno) in db['test']:
        print anno
    for (im,anno) in Viset(dbfile).split(strategy='train_test_shuffle', datastep=1000)['train']:
        print anno
    for (im,anno) in Viset(dbfile).split(strategy='train_test_shuffle', datastep=1000)['test']:
        print im
        print anno
    for (im,anno) in Viset(dbfile).split(strategy='train_test_shuffle', datastep=1000, asyncread=False)['test']:
        print anno
        imshow(im)

def test_labeling(dbfile):
    print '[test_viset.test_split]: dataset labeling'
    db = Viset(dbfile)
    print db.y(db.labels()[0])

    
def test_verbosity(dbfile):
    print '[test_viset.test_verbosity]: verbosity is true'
    db = Viset(dbfile, asyncread=False, verbose=True)
    (im,anno) = db[0].next()
    print '[test_viset.test_verbosity]: verbosity is false'
    db = Viset(dbfile, asyncread=False, verbose=False)
    (im,anno) = db[0].next()
    
    

def main():
    dbfile = test_create()
    test_open(dbfile)
    test_summary(dbfile)
    test_query(dbfile)
    test_split(dbfile)
    test_verbosity(dbfile)    
        

  
if __name__ == '__main__':
  main()

  
