import os
import os.path as path
from viset.util import quietprint, isurl, isfile
import pylab
import hashlib
import viset.dataset
import time

class File(object):
    URI = None
    URL = None    
    CACHEROOT = os.environ.get('VISYM_CACHE')
    if CACHEROOT is None:
        CACHEROOT = path.join(os.environ['HOME'],'.visym')    
    CACHEDIR = path.join(CACHEROOT, 'cache')
    if not path.exists(CACHEDIR):
        os.makedirs(CACHEDIR)
    OBJ = None
    VERBOSE = False
    CACHEFILE = None
    
    def __getitem__(self, k):
        if self.OBJ is None:
            self.get()
        return self.OBJ.__getitem__(k)  # numpy index

    def fetch(self):
        if isfile(self.CACHEFILE):
            pass
        elif isurl(self.URL):
            self.CACHEFILE = path.join(self.CACHEDIR, hashlib.sha1(self.URL).hexdigest() + os.path.splitext(self.URL)[1])
            if not isfile(self.CACHEFILE):
                quietprint('[viset.types]: fetching \'' + str(self.URL) + '\'' + ' to cached file \'' + self.CACHEFILE + '\'', self.VERBOSE)             
                viset.download.download(self.URL, self.CACHEFILE, verbose = self.VERBOSE)                        
        else:
            IOError('invalid URL')
            
    def pack(self):
        # serialize
        pass
        
    def get(self):
        try:
            self.fetch()
        except:
            quietprint('[viset.types]: download failed...skipping', self.VERBOSE)                                 
            time.sleep(1)  # for python ctrl-c
            return None
        try:
            self.unpack()
        except:
            quietprint('[viset.types]: unpack failed...clearing cache and refetching', self.VERBOSE)                                             
            os.remove(self.CACHEFILE)
            self.fetch()
            self.unpack()
        return self.OBJ

class Image(File):
    def __init__(self, uri = None, cacheroot = None, cachefile = None, obj = None, verbose = True):
        self.URI = uri
        self.URL = uri # FIXME
        self.OBJ = obj
        self.VERBOSE = verbose
        if cacheroot is not None:
            self.CACHEROOT = cacheroot
        if cachefile is not None:
            self.CACHEFILE = cachefile
        if isfile(self.URI):
            self.CACHEFILE = uri

    def __repr__(self):
        return str('<viset.image: obj=' + str(type(self.OBJ)) + ', cached=' + str(self.CACHEFILE is not None) + ', URI=\'' + str(self.URI) + '\'>')        

    def unpack(self):
        # convert cached file to object (unserialize)
        if not isfile(self.CACHEFILE):
            IOError('invalid cachefile')            
        quietprint('[viset.types]: reading image \'' + self.CACHEFILE + '\' to numpy.ndarray object', self.VERBOSE) 
        self.OBJ = pylab.imread(self.CACHEFILE)
    

class Data(File):
    def __init__(self, uri = None, cacheroot = None, cachefile = None, obj = None, verbose = False):
        self.URI = uri
        self.CACHEFILE = cachefile
        self.OBJ = obj
        self.VERBOSE = verbose
        if cacheroot is not None:
            self.CACHEROOT = cacheroot
        if isfile(self.URI):
            self.CACHEFILE = uri
        
    def __repr__(self):
        return str('<viset.data: obj=' + str(type(self.OBJ)) + ', cached=' + str(self.CACHEFILE is not None) + ', URI=\'' + str(self.URI) + '\'>')

    def unpack(self):
        quietprint('[viset.types]: unpickling python object from \'' + self.CACHEFILE + '\'', self.VERBOSE)         
        pass
    

class CustomImage(File):
    def __init__(self, cachedir = None, index = None, verbose = False, imreadfunc=None):    
        self.imreadfunc = imreadfunc
        self.cachedir = cachedir
        self.index = index
        self.verbose = verbose

    def __repr__(self):
        return str('<viset.customimage: reader=' + str(type(self.readfunc)) + ', index=' + str(self.index) + '>')
        
    def get(self):
        return self.imreadfunc(self.index, self.cachedir)
        
    
