import urllib
import urlparse
import string
import os.path
from os import path

def isurl(path):
    return urlparse.urlparse(path).scheme != ""

def tolist(x):
    if type(x) is list:
        return x
    else:
        return [x]
    
def isimg(path):
    (filename, ext) = os.path.splitext(path)
    if ext.lower() in ['.jpg','.jpeg','.png','.tif','.tiff','.pgm','.ppm','.gif',]:
        return True
    else:
        return False

def isfile(path):
    return os.path.isfile(str(path))

def isviset(obj):
    return (str(type(obj)) in ['<class \'viset.types.Image\'>', '<class \'viset.types.Data\'>'])

def isarchive(path):
    (filename, ext) = os.path.splitext(path)
    if ext.lower() in ['.egg','.jar','.tar','.tar.bz2','.tar.gz','.tgz','.tz2','.zip']:
        return True
    else:
        return False

def isxml(path):
    (filename, ext) = os.path.splitext(path)
    if ext.lower() in ['.xml']:
        return True
    else:
        return False

def ishdf5(path):
    (filename, ext) = os.path.splitext(path)
    if ext.lower() in ['.h5']:
        return True
    else:
        return False

def quietprint(mystr, is_verbose):
    if is_verbose:
        print mystr



def cacheroot():        
    cacheroot = os.environ.get('VISYM_CACHE')
    if cacheroot is None:
        cacheroot = path.join(os.environ['HOME'],'.visym')
    return cacheroot
        
def incache(path):
    return os.path.join(cacheroot(), path)

def iscached(path):
    return os.path.isfile(incache(path))

        
