from viset.ethzshapes import ETHZShapeClasses
from viset.dataset import Viset
from viset.show import imshow, imbbox

def main():
  print '[test_ethzshapes]: Creating vision dataset for ethzshapes'
  dbfile = ETHZShapeClasses().export()
  print 'Exporting dataset to redistributable HDF5 file "' + dbfile + '"'

  print '[test_ethzshapes]: Displaying all images in "' + dbfile + '"'
  db = Viset(dbfile, asyncread=False)
  for (im,annotation) in db[0]:
    print 'Image=' + str(annotation['id_img']) + ' Category=' + annotation['category']
    imbbox(im,annotation['bbox_xmin'],annotation['bbox_xmax'],annotation['bbox_ymin'],annotation['bbox_ymax'], bboxcaption=annotation['category'])

if __name__ == '__main__':
  main()
        
