import tables
import os
from os import path
#import viset.download  
from viset.dataset import DetectionViset, UrlViset
import httplib2
from BeautifulSoup import BeautifulSoup, SoupStrainer # EXTERNAL
import urlparse
import string
import viset.util
from viset.util import quietprint

class LabelMe(DetectionViset, UrlViset):
    def scrape(self, baseurl, keeptest):
        http = httplib2.Http()
        (status, response) = http.request(baseurl)
        filelist = []
        for link in BeautifulSoup(response, parseOnlyThese=SoupStrainer('a')):
            if (hasattr(link, 'href')) and (link.text not in ['Name','Last modified','Size','Description','Parent Directory']):
                dirurl = urlparse.urljoin(baseurl, link['href']) # relative link
                #        print 'Directory: ' + dirurl
                (status, response) = http.request(dirurl)
                for filelink in BeautifulSoup(response, parseOnlyThese=SoupStrainer('a')):
                    if (hasattr(filelink, 'href')) and (filelink.text not in ['Name','Last modified','Size','Description','Parent Directory']):
                        fileurl = urlparse.urljoin(dirurl, filelink['href'])
                        if keeptest(fileurl): 
                            print '[viset.labelme]: ' + fileurl              
                            filelist.append(fileurl) 
        return filelist
  
    def export(self, redo=False):    
        # Create new database
        (self.dbobj, dbname, dbfile, dburl, cachedir) = self.create(self.dbname, self.dbtype, self.dbimtype, self.dbversion)

        # Fetch data necessary to initial construction
        print('[viset.labelme]: scraping imagery from ' + self.IMURL)
        imlist = self.scrape(self.IMURL, viset.util.isimg)
        print('[viset.labelme]: scraping annotations from ' + self.ANNOURL)        
        annolist = self.scrape(self.ANNOURL, viset.util.isxml)    

        # Create me (image list only for now)
        id = 0
        for im in imlist:
            self.add_detection(0, '', id, 0,0,0,0)
            id += 1
        self.write()
        id = 0
        for im in imlist:
            self.add_image(id, im, 0, 0)  # no detections            
            id += 1
        self.write()            

        # Cleanup
        self.close()
        return dbfile

class LabelMe3(LabelMe):
    IMURL = 'http://people.csail.mit.edu/brussell/research/LabelMe/Images/'
    ANNOURL = 'http://people.csail.mit.edu/brussell/research/LabelMe/Annotations/'
    SHA1 = None
    dbname = 'labelme3'




  ## Many annotations in polygon XML format for each image
  ## store as a finite list of empty columns for max 100 points

  ## Each annotation is scraped from xml document
  ## images are defined by URL from scraping entry

  ## add a DetectionPolygonTable 

  ## http://stackoverflow.com/questions/1080411/retrieve-links-from-web-page-using-python-and-beautiful-soup


  ## matplotlib supports polygons
  ## http://matplotlib.org/api/pyplot_api.html#matplotlib.pyplot.fill

  ## https://github.com/mpitid/pylabelme
