import tables
import os
from os import path
import viset.download
from viset.dataset import SegmentationViset, ImageArchiveViset
from viset.util import isimg

class WeizmannHorses(SegmentationViset, ImageArchiveViset):
    def export(self, redo=False):
        # Create empty database
        self.create()

        # Fetch data necessary to initial construction
        viset.download.cache_and_extract(self.URL, self.cachedir, sha1=self.SHA1)              

        # Write images to database
        id_img = 0  
        imdir = path.join(self.cachedir, self.IMGPATH)      
        for filename in os.listdir(imdir):
            if isimg(filename):
                self.add_image(id_img, path.join(imdir, filename), 1, id_img)
                id_img += 1
        self.write()

        # Write labels to database
        id_img = 0
        imdir = path.join(self.cachedir, self.MASKPATH)              
        for filename in os.listdir(imdir):
            if isimg(filename):
                self.dbview.add_segmentation(path.join(imdir, filename), id_img)
                id_img += 1
        self.write()

        # Add one data package for download
        self.add_package(self.URL, self.SHA1)
        
        # Cleanup
        self.close()
        return self.dbfile
    
class WeizmannHorsesSingleScale(WeizmannHorses):
  URL = 'http://jamie.shotton.org/work/data/WeizmannSingleScale.zip'
  SHA1 = '2d90eedfedea31ebd97294a9268c06fbd4e52332'
  IMGPATH = os.path.join('horses','images')
  MASKPATH = os.path.join('horses','masks')  
  _dbname = 'weizmann_horses_singlescale'
  
class WeizmannHorsesMultiScale(WeizmannHorses):
  URL = 'http://jamie.shotton.org/work/data/WeizmannMultiScale.zip'
  SHA1 = None
  IMGPATH = 'Images'
  MASKPATH = 'Masks'
  _dbname = 'weizmann_horses_multiscale'
    


