from viset.imagenet import ImageNetFall2011
from viset.dataset import Viset
from viset.show import imshow
from viset.util import iscached, incache


if __name__ == '__main__':
    if not iscached('imagenet_fall2011.h5'):
        print 'Creating vision dataset for imagenet-fall2011'
        dbfile = ImageNetFall2011().export()
    else:
        print 'Reading imagenet from cache'
        dbfile = incache('imagenet_fall2011.h5')
  
    # Import an existing viset 
    print 'Displaying all images in viset (VISion dataSET) "' + dbfile + '"'
    db = Viset(dbfile, datastep=100, asyncread=False, verbose=True)
    for (im,annotation) in db[0]:
        print 'Image=' + str(annotation['id_img']) + ' Category=' + annotation['category']
        if im is not None:
            imshow(im)
