from viset.mnist import MNIST
from viset.dataset import Viset
from viset.show import imshow
from time import sleep
from viset.util import iscached, incache

def main():
    if not iscached('mnist.h5'):
        print 'Creating vision dataset for mnist'
        dbfile = MNIST().export()  
    else:
        print 'Reading cached dataset for mnist'
        dbfile = incache('mnist.h5')

    db = Viset(dbfile, async=False, verbose=True)
    for (im,annotation) in db[0]:
        print 'Image=' + str(annotation['id_img']) + ' Category=' + annotation['category']
        imshow(im, title=annotation['category'])
        sleep(0.2)
        
if __name__ == '__main__':
  main()

