from viset.weizmannhorses import WeizmannHorsesMultiScale
from viset.dataset import Viset
from viset.show import imshow

def main():
  dbfile = WeizmannHorsesMultiScale().export()
  db = Viset(dbfile, datastep=1, async=False, verbose=True)
  for (im,annotation) in db[0]:
    imshow(im, title=annotation['category'])
    if annotation['mask'] is not None:
		imshow(annotation['mask'], title='mask')
    
if __name__ == '__main__':
  main()

  
