import os
import os.path as path
import viset.util
from viset.util import quietprint, isurl, isfile
import time
import socket


class Async(object):
    """Mirrors Python's AsyncResult class"""
    _obj = None    
    def successful():
        return (self._obj is not None)
    def get():
        raise IOError('this should be overloaded')
    def wait(timeout):
        socket.setdefaulttimeout(timeout)  # do not set globally        
    def ready():
        return (self._obj is not None)


class File(Async):
    _url = None
    _verbose = False
    _cache = None
    
    def get(self):
        self._obj = self._cache.get(self._url)
        return self._obj

    
class Image(File):
    def __init__(self, url, cache=None, verbose=True):
        self._verbose = verbose
        if cache is None:
            self._cache = Cache(verbose=self._verbose)
        else:
            self._cache = cache
        self._url = url
        
    def __repr__(self):
        return str('<viset.image: obj=' + str(type(self._obj)) + ', cached=' + str(self._cache.iscached(self._url)) + ', URL=\'' + str(self._url) + '\'>')        

