from viset.pascalvoc import PascalVOC2012
from viset.dataset import Viset
from viset.show import imshow

def main():
    try:
        db = Viset('pacscalvoc_2012.h5', datastep=100, async=False, verbose=True)
    except:
        dbfile = PascalVOC2012().export()
        db = Viset(dbfile, datastep=100, async=False, verbose=True)

    db = Viset(dbfile, async=False, verbose=True)
    for (im,annotation) in db[0]:
        print 'Image=' + str(annotation['id_img']) + ' Category=' + annotation['category']
        imshow(im, title=annotation['category'])
        
if __name__ == '__main__':
  main()

