import tables
import os
from os import path
from viset.dataset import CategorizationViset

class Caltech(CategorizationViset):
    def export(self, redo=False):
        # Create empty database
        self.create()

        # Fetch data necessary to initial construction
        pkgdir = self.dbcache.get(self.URL, sha1=self.SHA1)
        
        # Write images to database
        id_img = 0  
        labeldir = path.join(pkgdir, self.PATH)      
        for label in os.listdir(labeldir):
            imdir = path.join(labeldir,label)        
            for im in os.listdir(imdir):
                self.add_image(id_img, path.join(self.PATH,label,im), 1, id_img, url=self.URL)
                id_img += 1
        self.write()

        # Write labels to categorization view in database
        id_anno = 0
        id_category = 0
        for label in os.listdir(labeldir):
            imdir = path.join(labeldir,label)        
            for im in os.listdir(imdir):
                self.dbview.add_categorization(id_category, label, id_anno)
                id_anno += 1
            id_category += 1
        self.write()
        
        # Cleanup
        self.close()
        return self.dbfile
    
class Caltech101(Caltech):
  URL = ('http://www.vision.caltech.edu/Image_Datasets/Caltech101/101_ObjectCategories.tar.gz')
  SHA1 = 'b8ca4fe15bcd0921dfda882bd6052807e63b4c96'
  PATH = '101_ObjectCategories'
  _dbname = 'caltech101'
  
class Caltech256(Caltech):
  URL = ('http://www.vision.caltech.edu/Image_Datasets/Caltech256/256_ObjectCategories.tar')
  SHA1 = '2195e9a478cf78bd23a1fe51f4dabe1c33744a1c'
  PATH = '256_ObjectCategories'
  _dbname = 'caltech256'
    


