from viset.caltech import Caltech101
from viset.dataset import Viset
from viset.show import imshow

def main():
    try:
        db = Viset('caltech101.h5', datastep=100, async=False, verbose=True)
    except:
        dbfile = Caltech101().export()
        db = Viset(dbfile, datastep=100, async=False, verbose=True)

    for (im,annotation) in db[0]:
        print 'Image=' + str(annotation['id_img']) + ' Category=' + annotation['category']
        imshow(im, title=annotation['category'])

if __name__ == '__main__':
  main()

  
