from viset.mnist import MNIST
from viset.dataset import Viset
from viset.show import imshow
from time import sleep

def main():
    try:
        db = Viset('mnist.h5', datastep=100, async=False, verbose=True)
    except:
        dbfile = MNIST().export()
        db = Viset(dbfile, datastep=100, async=False, verbose=True)

    for (im,annotation) in db[0]:
        print 'Image=' + str(annotation['id_img']) + ' Category=' + annotation['category']
        imshow(im, title=annotation['category'])
        
if __name__ == '__main__':
  main()

