import tables
import os
from os import path
import viset.download
from viset.dataset import DetectionViset
import numpy as np

class ETHZShapes(DetectionViset):      
    def export(self, redo=False):
        # Create empty database
        self.create()
        
        # Fetch data necessary to initial construction
        pkgdir = self.dbcache.get(self.URL, sha1=self.SHA1)
        
        # Write dataset
        id_img = 0
        id_anno = 0     
        id_category = 0
        labeldir = self.LABELS
        for label in labeldir:
            imdir = path.join(pkgdir,self.PATH,label)        
            for filename in os.listdir(imdir):
                if filename.endswith(".jpg") and not filename.startswith('.'):
                    # Write detections
                    n_detections = 0
                    id_detectionstart = id_anno
                    gtfile = path.join(pkgdir,self.PATH,label,os.path.splitext(path.basename(filename))[0] + '_' + label.lower()+'.groundtruth')
                    if not os.path.isfile(gtfile):
                        gtfile = path.join(pkgdir,self.PATH,label,os.path.splitext(path.basename(filename))[0] + '_' + label.lower()+'s.groundtruth') # plural hack
                    for line in open(gtfile,'r'):
                        if line.strip() == '':
                            continue
                        (xmin,ymin,xmax,ymax) = line.strip().split()
                        self.dbview.add_detection(id_category, label, id_img, np.float32(xmin), np.float32(xmax), np.float32(ymin), np.float32(ymax))
                        id_anno += 1
                        n_detections += 1              
                    
                    # Write image
                    self.add_image(id_img, path.join(self.PATH,label,filename), n_detections, id_detectionstart, url=self.URL)
                    id_img += 1
            id_category += 1
                    
        # Cleanup
        self.close()
        return self.dbfile
    
class ETHZShapeClasses(ETHZShapes):
  URL = 'http://www.vision.ee.ethz.ch/datasets/downloads/ethz_shape_classes_v12.tgz'
  SHA1 = 'ae9b8fad2d170e098e5126ea9181d0843505a84b'
  PATH = 'ETHZShapeClasses-V1.2'
  LABELS = ['Applelogos','Bottles','Giraffes','Mugs','Swans']
  _dbname = 'ethzshapes'
  
class ETHZExtendedShapeClasses(ETHZShapes):
  URL = 'http://www.vision.ee.ethz.ch/datasets/downloads/extended_ethz_shapes.tgz'
  SHA1 = None
  PATH = 'extended_ethz_shapes'
  LABELS = ['apple','bottle','giraffe','hat','mug','starfish','swan']
  _dbname = 'ethzshapes_extended'

