import tables
import os
from os import path
import viset.download
from viset.dataset import Viset


class PascalVOC(Viset):
    def export(self, redo=False):
        # Create empty database
        self.create(view=['Categorization', 'Detection', 'Segmentation'])

        # Fetch data necessary to initial construction
        pkgdir = self.dbcache.get(self.URL, sha1=self.SHA1)

        # Write images to database
        id_img = 0  
        labeldir = path.join(pkgdir, self.PATH)      
        for label in os.listdir(labeldir):
            imdir = path.join(labeldir,label)        
            for im in os.listdir(imdir):
                self.add_image(id_img, path.join(self.PATH,label,im), 1, id_img, url=self.URL)
                id_img += 1
        self.write()

        # Write labels to categorization view in database
                
        id_anno = 0
        id_category = 0
        for label in os.listdir(labeldir):
            imdir = path.join(labeldir,label)        
            for im in os.listdir(imdir):
                self.dbview.add_categorization(id_category, label, id_anno)
                id_anno += 1
            id_category += 1
        self.write()
        
        # Cleanup
        self.close()
        return self.dbfile

class PascalVOC2012(PascalVOC):
  URL = 'http://pascallin.ecs.soton.ac.uk/challenges/VOC/voc2012/VOCtrainval_11-May-2012.tar'
  SHA1 = None
  SUBDIR = 'pascalvoc_2012'
  _dbname = 'pascalvoc_2012'
  
